// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model



/**
 * The spend objects that are associated with this budget. The `actualSpend` tracks how much you've used, cost, usage, RI units, or Savings Plans units and the `forecastedSpend` tracks how much that you're predicted to spend based on your historical usage profile.
 *
 * For example, if it's the 20th of the month and you have spent `50` dollars on Amazon EC2, your `actualSpend` is `50 USD`, and your `forecastedSpend` is `75 USD`.
 */
public class CalculatedSpend private constructor(builder: Builder) {
    /**
     * The amount of cost, usage, RI units, or Savings Plans units that you used.
     */
    public val actualSpend: aws.sdk.kotlin.services.budgets.model.Spend? = builder.actualSpend
    /**
     * The amount of cost, usage, RI units, or Savings Plans units that you're forecasted to use.
     */
    public val forecastedSpend: aws.sdk.kotlin.services.budgets.model.Spend? = builder.forecastedSpend

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.CalculatedSpend = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculatedSpend(")
        append("actualSpend=$actualSpend,")
        append("forecastedSpend=$forecastedSpend)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualSpend?.hashCode() ?: 0
        result = 31 * result + (forecastedSpend?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculatedSpend

        if (actualSpend != other.actualSpend) return false
        if (forecastedSpend != other.forecastedSpend) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.CalculatedSpend = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of cost, usage, RI units, or Savings Plans units that you used.
         */
        public var actualSpend: aws.sdk.kotlin.services.budgets.model.Spend? = null
        /**
         * The amount of cost, usage, RI units, or Savings Plans units that you're forecasted to use.
         */
        public var forecastedSpend: aws.sdk.kotlin.services.budgets.model.Spend? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.CalculatedSpend) : this() {
            this.actualSpend = x.actualSpend
            this.forecastedSpend = x.forecastedSpend
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.CalculatedSpend = CalculatedSpend(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.Spend] inside the given [block]
         */
        public fun actualSpend(block: aws.sdk.kotlin.services.budgets.model.Spend.Builder.() -> kotlin.Unit) {
            this.actualSpend = aws.sdk.kotlin.services.budgets.model.Spend.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.Spend] inside the given [block]
         */
        public fun forecastedSpend(block: aws.sdk.kotlin.services.budgets.model.Spend.Builder.() -> kotlin.Unit) {
            this.forecastedSpend = aws.sdk.kotlin.services.budgets.model.Spend.invoke(block)
        }
    }
}
