// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.budgets.model.Action
import aws.sdk.kotlin.services.budgets.model.BudgetsException
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetActionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBudgetActionOperationDeserializer: HttpDeserialize<UpdateBudgetActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateBudgetActionResponse {
        if (!response.status.isSuccess()) {
            throwUpdateBudgetActionError(context, response)
        }
        val builder = UpdateBudgetActionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateBudgetActionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateBudgetActionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BudgetsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceLockedException" -> ResourceLockedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BudgetsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBudgetActionOperationBody(builder: UpdateBudgetActionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountId"))
    val BUDGETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BudgetName"))
    val NEWACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NewAction"))
    val OLDACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OldAction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTID_DESCRIPTOR)
        field(BUDGETNAME_DESCRIPTOR)
        field(NEWACTION_DESCRIPTOR)
        field(OLDACTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTID_DESCRIPTOR.index -> builder.accountId = deserializeString()
                BUDGETNAME_DESCRIPTOR.index -> builder.budgetName = deserializeString()
                NEWACTION_DESCRIPTOR.index -> builder.newAction = deserializeActionDocument(deserializer)
                OLDACTION_DESCRIPTOR.index -> builder.oldAction = deserializeActionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
