// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.paginators

import aws.sdk.kotlin.services.budgets.BudgetsClient
import aws.sdk.kotlin.services.budgets.model.Action
import aws.sdk.kotlin.services.budgets.model.ActionHistory
import aws.sdk.kotlin.services.budgets.model.Budget
import aws.sdk.kotlin.services.budgets.model.BudgetNotificationsForAccount
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionHistoriesRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionHistoriesResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForAccountRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForAccountResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetNotificationsForAccountRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetNotificationsForAccountResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetsRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetsResponse
import aws.sdk.kotlin.services.budgets.model.DescribeNotificationsForBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeNotificationsForBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeSubscribersForNotificationRequest
import aws.sdk.kotlin.services.budgets.model.DescribeSubscribersForNotificationResponse
import aws.sdk.kotlin.services.budgets.model.Notification
import aws.sdk.kotlin.services.budgets.model.Subscriber
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeBudgetActionHistoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBudgetActionHistoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetActionHistoriesResponse]
 */
public fun BudgetsClient.describeBudgetActionHistoriesPaginated(initialRequest: DescribeBudgetActionHistoriesRequest): Flow<DescribeBudgetActionHistoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBudgetActionHistoriesPaginated.describeBudgetActionHistories(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBudgetActionHistoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetActionHistoriesResponse]
 */
public fun BudgetsClient.describeBudgetActionHistoriesPaginated(block: DescribeBudgetActionHistoriesRequest.Builder.() -> Unit): Flow<DescribeBudgetActionHistoriesResponse> =
    describeBudgetActionHistoriesPaginated(DescribeBudgetActionHistoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBudgetActionHistoriesPaginated]
 * to access the nested member [ActionHistory]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActionHistory]
 */
@JvmName("describeBudgetActionHistoriesResponseActionHistory")
public fun Flow<DescribeBudgetActionHistoriesResponse>.actionHistories(): Flow<ActionHistory> =
    transform() { response ->
        response.actionHistories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeBudgetActionsForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBudgetActionsForAccountRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetActionsForAccountResponse]
 */
public fun BudgetsClient.describeBudgetActionsForAccountPaginated(initialRequest: DescribeBudgetActionsForAccountRequest): Flow<DescribeBudgetActionsForAccountResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBudgetActionsForAccountPaginated.describeBudgetActionsForAccount(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBudgetActionsForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetActionsForAccountResponse]
 */
public fun BudgetsClient.describeBudgetActionsForAccountPaginated(block: DescribeBudgetActionsForAccountRequest.Builder.() -> Unit): Flow<DescribeBudgetActionsForAccountResponse> =
    describeBudgetActionsForAccountPaginated(DescribeBudgetActionsForAccountRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBudgetActionsForAccountPaginated]
 * to access the nested member [Action]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Action]
 */
@JvmName("describeBudgetActionsForAccountResponseAction")
public fun Flow<DescribeBudgetActionsForAccountResponse>.actions(): Flow<Action> =
    transform() { response ->
        response.actions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeBudgetActionsForBudgetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBudgetActionsForBudgetRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetActionsForBudgetResponse]
 */
public fun BudgetsClient.describeBudgetActionsForBudgetPaginated(initialRequest: DescribeBudgetActionsForBudgetRequest): Flow<DescribeBudgetActionsForBudgetResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBudgetActionsForBudgetPaginated.describeBudgetActionsForBudget(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBudgetActionsForBudgetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetActionsForBudgetResponse]
 */
public fun BudgetsClient.describeBudgetActionsForBudgetPaginated(block: DescribeBudgetActionsForBudgetRequest.Builder.() -> Unit): Flow<DescribeBudgetActionsForBudgetResponse> =
    describeBudgetActionsForBudgetPaginated(DescribeBudgetActionsForBudgetRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBudgetActionsForBudgetPaginated]
 * to access the nested member [Action]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Action]
 */
@JvmName("describeBudgetActionsForBudgetResponseAction")
public fun Flow<DescribeBudgetActionsForBudgetResponse>.actions(): Flow<Action> =
    transform() { response ->
        response.actions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeBudgetNotificationsForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBudgetNotificationsForAccountRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetNotificationsForAccountResponse]
 */
public fun BudgetsClient.describeBudgetNotificationsForAccountPaginated(initialRequest: DescribeBudgetNotificationsForAccountRequest): Flow<DescribeBudgetNotificationsForAccountResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBudgetNotificationsForAccountPaginated.describeBudgetNotificationsForAccount(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBudgetNotificationsForAccountResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetNotificationsForAccountResponse]
 */
public fun BudgetsClient.describeBudgetNotificationsForAccountPaginated(block: DescribeBudgetNotificationsForAccountRequest.Builder.() -> Unit): Flow<DescribeBudgetNotificationsForAccountResponse> =
    describeBudgetNotificationsForAccountPaginated(DescribeBudgetNotificationsForAccountRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBudgetNotificationsForAccountPaginated]
 * to access the nested member [BudgetNotificationsForAccount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BudgetNotificationsForAccount]
 */
@JvmName("describeBudgetNotificationsForAccountResponseBudgetNotificationsForAccount")
public fun Flow<DescribeBudgetNotificationsForAccountResponse>.budgetNotificationsForAccount(): Flow<BudgetNotificationsForAccount> =
    transform() { response ->
        response.budgetNotificationsForAccount?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeBudgetPerformanceHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBudgetPerformanceHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetPerformanceHistoryResponse]
 */
public fun BudgetsClient.describeBudgetPerformanceHistoryPaginated(initialRequest: DescribeBudgetPerformanceHistoryRequest): Flow<DescribeBudgetPerformanceHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBudgetPerformanceHistoryPaginated.describeBudgetPerformanceHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBudgetPerformanceHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetPerformanceHistoryResponse]
 */
public fun BudgetsClient.describeBudgetPerformanceHistoryPaginated(block: DescribeBudgetPerformanceHistoryRequest.Builder.() -> Unit): Flow<DescribeBudgetPerformanceHistoryResponse> =
    describeBudgetPerformanceHistoryPaginated(DescribeBudgetPerformanceHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeBudgetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBudgetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetsResponse]
 */
public fun BudgetsClient.describeBudgetsPaginated(initialRequest: DescribeBudgetsRequest): Flow<DescribeBudgetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBudgetsPaginated.describeBudgets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBudgetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBudgetsResponse]
 */
public fun BudgetsClient.describeBudgetsPaginated(block: DescribeBudgetsRequest.Builder.() -> Unit): Flow<DescribeBudgetsResponse> =
    describeBudgetsPaginated(DescribeBudgetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBudgetsPaginated]
 * to access the nested member [Budget]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Budget]
 */
@JvmName("describeBudgetsResponseBudget")
public fun Flow<DescribeBudgetsResponse>.budgets(): Flow<Budget> =
    transform() { response ->
        response.budgets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeNotificationsForBudgetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeNotificationsForBudgetRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationsForBudgetResponse]
 */
public fun BudgetsClient.describeNotificationsForBudgetPaginated(initialRequest: DescribeNotificationsForBudgetRequest): Flow<DescribeNotificationsForBudgetResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeNotificationsForBudgetPaginated.describeNotificationsForBudget(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeNotificationsForBudgetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationsForBudgetResponse]
 */
public fun BudgetsClient.describeNotificationsForBudgetPaginated(block: DescribeNotificationsForBudgetRequest.Builder.() -> Unit): Flow<DescribeNotificationsForBudgetResponse> =
    describeNotificationsForBudgetPaginated(DescribeNotificationsForBudgetRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeNotificationsForBudgetPaginated]
 * to access the nested member [Notification]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Notification]
 */
@JvmName("describeNotificationsForBudgetResponseNotification")
public fun Flow<DescribeNotificationsForBudgetResponse>.notifications(): Flow<Notification> =
    transform() { response ->
        response.notifications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSubscribersForNotificationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSubscribersForNotificationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSubscribersForNotificationResponse]
 */
public fun BudgetsClient.describeSubscribersForNotificationPaginated(initialRequest: DescribeSubscribersForNotificationRequest): Flow<DescribeSubscribersForNotificationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSubscribersForNotificationPaginated.describeSubscribersForNotification(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSubscribersForNotificationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSubscribersForNotificationResponse]
 */
public fun BudgetsClient.describeSubscribersForNotificationPaginated(block: DescribeSubscribersForNotificationRequest.Builder.() -> Unit): Flow<DescribeSubscribersForNotificationResponse> =
    describeSubscribersForNotificationPaginated(DescribeSubscribersForNotificationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSubscribersForNotificationPaginated]
 * to access the nested member [Subscriber]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Subscriber]
 */
@JvmName("describeSubscribersForNotificationResponseSubscriber")
public fun Flow<DescribeSubscribersForNotificationResponse>.subscribers(): Flow<Subscriber> =
    transform() { response ->
        response.subscribers?.forEach {
            emit(it)
        }
    }
