// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets.model



/**
 * A history of the state of a budget at the end of the budget's specified time period.
 */
public class BudgetPerformanceHistory private constructor(builder: Builder) {
    /**
     * A string that represents the budget name. The ":" and "\" characters aren't allowed.
     */
    public val budgetName: kotlin.String? = builder.budgetName
    /**
     * The type of a budget. It must be one of the following types:
     *
     * `COST`, `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`, `SAVINGS_PLANS_UTILIZATION`, or `SAVINGS_PLANS_COVERAGE`.
     */
    public val budgetType: aws.sdk.kotlin.services.budgets.model.BudgetType? = builder.budgetType
    /**
     * A list of amounts of cost or usage that you created budgets for, which are compared to your actual costs or usage.
     */
    public val budgetedAndActualAmountsList: List<BudgetedAndActualAmounts>? = builder.budgetedAndActualAmountsList
    /**
     * The history of the cost filters for a budget during the specified time period.
     */
    public val costFilters: Map<String, List<String>>? = builder.costFilters
    /**
     * The history of the cost types for a budget during the specified time period.
     */
    public val costTypes: aws.sdk.kotlin.services.budgets.model.CostTypes? = builder.costTypes
    /**
     * The time unit of the budget, such as MONTHLY or QUARTERLY.
     */
    public val timeUnit: aws.sdk.kotlin.services.budgets.model.TimeUnit? = builder.timeUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.budgets.model.BudgetPerformanceHistory = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BudgetPerformanceHistory(")
        append("budgetName=$budgetName,")
        append("budgetType=$budgetType,")
        append("budgetedAndActualAmountsList=$budgetedAndActualAmountsList,")
        append("costFilters=$costFilters,")
        append("costTypes=$costTypes,")
        append("timeUnit=$timeUnit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = budgetName?.hashCode() ?: 0
        result = 31 * result + (budgetType?.hashCode() ?: 0)
        result = 31 * result + (budgetedAndActualAmountsList?.hashCode() ?: 0)
        result = 31 * result + (costFilters?.hashCode() ?: 0)
        result = 31 * result + (costTypes?.hashCode() ?: 0)
        result = 31 * result + (timeUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BudgetPerformanceHistory

        if (budgetName != other.budgetName) return false
        if (budgetType != other.budgetType) return false
        if (budgetedAndActualAmountsList != other.budgetedAndActualAmountsList) return false
        if (costFilters != other.costFilters) return false
        if (costTypes != other.costTypes) return false
        if (timeUnit != other.timeUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.budgets.model.BudgetPerformanceHistory = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string that represents the budget name. The ":" and "\" characters aren't allowed.
         */
        public var budgetName: kotlin.String? = null
        /**
         * The type of a budget. It must be one of the following types:
         *
         * `COST`, `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`, `SAVINGS_PLANS_UTILIZATION`, or `SAVINGS_PLANS_COVERAGE`.
         */
        public var budgetType: aws.sdk.kotlin.services.budgets.model.BudgetType? = null
        /**
         * A list of amounts of cost or usage that you created budgets for, which are compared to your actual costs or usage.
         */
        public var budgetedAndActualAmountsList: List<BudgetedAndActualAmounts>? = null
        /**
         * The history of the cost filters for a budget during the specified time period.
         */
        public var costFilters: Map<String, List<String>>? = null
        /**
         * The history of the cost types for a budget during the specified time period.
         */
        public var costTypes: aws.sdk.kotlin.services.budgets.model.CostTypes? = null
        /**
         * The time unit of the budget, such as MONTHLY or QUARTERLY.
         */
        public var timeUnit: aws.sdk.kotlin.services.budgets.model.TimeUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.budgets.model.BudgetPerformanceHistory) : this() {
            this.budgetName = x.budgetName
            this.budgetType = x.budgetType
            this.budgetedAndActualAmountsList = x.budgetedAndActualAmountsList
            this.costFilters = x.costFilters
            this.costTypes = x.costTypes
            this.timeUnit = x.timeUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.budgets.model.BudgetPerformanceHistory = BudgetPerformanceHistory(this)

        /**
         * construct an [aws.sdk.kotlin.services.budgets.model.CostTypes] inside the given [block]
         */
        public fun costTypes(block: aws.sdk.kotlin.services.budgets.model.CostTypes.Builder.() -> kotlin.Unit) {
            this.costTypes = aws.sdk.kotlin.services.budgets.model.CostTypes.invoke(block)
        }
    }
}
