// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.budgets.model.*
import aws.sdk.kotlin.services.budgets.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Budgets"
public const val ServiceApiVersion: String = "2016-10-20"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultBudgetsClient(override val config: BudgetsClient.Config) : BudgetsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a budget and, if included, notifications and subscribers.
     *
     * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples) section.
     */
    override suspend fun createBudget(input: CreateBudgetRequest): CreateBudgetResponse {
        val op = SdkHttpOperation.build<CreateBudgetRequest, CreateBudgetResponse> {
            serializer = CreateBudgetOperationSerializer()
            deserializer = CreateBudgetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBudget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a budget action.
     */
    override suspend fun createBudgetAction(input: CreateBudgetActionRequest): CreateBudgetActionResponse {
        val op = SdkHttpOperation.build<CreateBudgetActionRequest, CreateBudgetActionResponse> {
            serializer = CreateBudgetActionOperationSerializer()
            deserializer = CreateBudgetActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBudgetAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a notification. You must create the budget before you create the associated notification.
     */
    override suspend fun createNotification(input: CreateNotificationRequest): CreateNotificationResponse {
        val op = SdkHttpOperation.build<CreateNotificationRequest, CreateNotificationResponse> {
            serializer = CreateNotificationOperationSerializer()
            deserializer = CreateNotificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNotification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
     */
    override suspend fun createSubscriber(input: CreateSubscriberRequest): CreateSubscriberResponse {
        val op = SdkHttpOperation.build<CreateSubscriberRequest, CreateSubscriberResponse> {
            serializer = CreateSubscriberOperationSerializer()
            deserializer = CreateSubscriberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSubscriber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a budget. You can delete your budget at any time.
     *
     * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
     */
    override suspend fun deleteBudget(input: DeleteBudgetRequest): DeleteBudgetResponse {
        val op = SdkHttpOperation.build<DeleteBudgetRequest, DeleteBudgetResponse> {
            serializer = DeleteBudgetOperationSerializer()
            deserializer = DeleteBudgetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBudget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a budget action.
     */
    override suspend fun deleteBudgetAction(input: DeleteBudgetActionRequest): DeleteBudgetActionResponse {
        val op = SdkHttpOperation.build<DeleteBudgetActionRequest, DeleteBudgetActionResponse> {
            serializer = DeleteBudgetActionOperationSerializer()
            deserializer = DeleteBudgetActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBudgetAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a notification.
     *
     * Deleting a notification also deletes the subscribers that are associated with the notification.
     */
    override suspend fun deleteNotification(input: DeleteNotificationRequest): DeleteNotificationResponse {
        val op = SdkHttpOperation.build<DeleteNotificationRequest, DeleteNotificationResponse> {
            serializer = DeleteNotificationOperationSerializer()
            deserializer = DeleteNotificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNotification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subscriber.
     *
     * Deleting the last subscriber to a notification also deletes the notification.
     */
    override suspend fun deleteSubscriber(input: DeleteSubscriberRequest): DeleteSubscriberResponse {
        val op = SdkHttpOperation.build<DeleteSubscriberRequest, DeleteSubscriberResponse> {
            serializer = DeleteSubscriberOperationSerializer()
            deserializer = DeleteSubscriberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSubscriber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a budget.
     *
     * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples) section.
     */
    override suspend fun describeBudget(input: DescribeBudgetRequest): DescribeBudgetResponse {
        val op = SdkHttpOperation.build<DescribeBudgetRequest, DescribeBudgetResponse> {
            serializer = DescribeBudgetOperationSerializer()
            deserializer = DescribeBudgetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a budget action detail.
     */
    override suspend fun describeBudgetAction(input: DescribeBudgetActionRequest): DescribeBudgetActionResponse {
        val op = SdkHttpOperation.build<DescribeBudgetActionRequest, DescribeBudgetActionResponse> {
            serializer = DescribeBudgetActionOperationSerializer()
            deserializer = DescribeBudgetActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgetAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a budget action history detail.
     */
    override suspend fun describeBudgetActionHistories(input: DescribeBudgetActionHistoriesRequest): DescribeBudgetActionHistoriesResponse {
        val op = SdkHttpOperation.build<DescribeBudgetActionHistoriesRequest, DescribeBudgetActionHistoriesResponse> {
            serializer = DescribeBudgetActionHistoriesOperationSerializer()
            deserializer = DescribeBudgetActionHistoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgetActionHistories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes all of the budget actions for an account.
     */
    override suspend fun describeBudgetActionsForAccount(input: DescribeBudgetActionsForAccountRequest): DescribeBudgetActionsForAccountResponse {
        val op = SdkHttpOperation.build<DescribeBudgetActionsForAccountRequest, DescribeBudgetActionsForAccountResponse> {
            serializer = DescribeBudgetActionsForAccountOperationSerializer()
            deserializer = DescribeBudgetActionsForAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgetActionsForAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes all of the budget actions for a budget.
     */
    override suspend fun describeBudgetActionsForBudget(input: DescribeBudgetActionsForBudgetRequest): DescribeBudgetActionsForBudgetResponse {
        val op = SdkHttpOperation.build<DescribeBudgetActionsForBudgetRequest, DescribeBudgetActionsForBudgetResponse> {
            serializer = DescribeBudgetActionsForBudgetOperationSerializer()
            deserializer = DescribeBudgetActionsForBudgetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgetActionsForBudget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the budget names and notifications that are associated with an account.
     */
    override suspend fun describeBudgetNotificationsForAccount(input: DescribeBudgetNotificationsForAccountRequest): DescribeBudgetNotificationsForAccountResponse {
        val op = SdkHttpOperation.build<DescribeBudgetNotificationsForAccountRequest, DescribeBudgetNotificationsForAccountResponse> {
            serializer = DescribeBudgetNotificationsForAccountOperationSerializer()
            deserializer = DescribeBudgetNotificationsForAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgetNotificationsForAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets. Budget history isn't available for `ANNUAL` budgets.
     */
    override suspend fun describeBudgetPerformanceHistory(input: DescribeBudgetPerformanceHistoryRequest): DescribeBudgetPerformanceHistoryResponse {
        val op = SdkHttpOperation.build<DescribeBudgetPerformanceHistoryRequest, DescribeBudgetPerformanceHistoryResponse> {
            serializer = DescribeBudgetPerformanceHistoryOperationSerializer()
            deserializer = DescribeBudgetPerformanceHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgetPerformanceHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the budgets that are associated with an account.
     *
     * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples) section.
     */
    override suspend fun describeBudgets(input: DescribeBudgetsRequest): DescribeBudgetsResponse {
        val op = SdkHttpOperation.build<DescribeBudgetsRequest, DescribeBudgetsResponse> {
            serializer = DescribeBudgetsOperationSerializer()
            deserializer = DescribeBudgetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBudgets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the notifications that are associated with a budget.
     */
    override suspend fun describeNotificationsForBudget(input: DescribeNotificationsForBudgetRequest): DescribeNotificationsForBudgetResponse {
        val op = SdkHttpOperation.build<DescribeNotificationsForBudgetRequest, DescribeNotificationsForBudgetResponse> {
            serializer = DescribeNotificationsForBudgetOperationSerializer()
            deserializer = DescribeNotificationsForBudgetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotificationsForBudget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the subscribers that are associated with a notification.
     */
    override suspend fun describeSubscribersForNotification(input: DescribeSubscribersForNotificationRequest): DescribeSubscribersForNotificationResponse {
        val op = SdkHttpOperation.build<DescribeSubscribersForNotificationRequest, DescribeSubscribersForNotificationResponse> {
            serializer = DescribeSubscribersForNotificationOperationSerializer()
            deserializer = DescribeSubscribersForNotificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSubscribersForNotification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Executes a budget action.
     */
    override suspend fun executeBudgetAction(input: ExecuteBudgetActionRequest): ExecuteBudgetActionResponse {
        val op = SdkHttpOperation.build<ExecuteBudgetActionRequest, ExecuteBudgetActionResponse> {
            serializer = ExecuteBudgetActionOperationSerializer()
            deserializer = ExecuteBudgetActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteBudgetAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a budget. You can change every part of a budget except for the `budgetName` and the `calculatedSpend`. When you modify a budget, the `calculatedSpend` drops to zero until Amazon Web Services has new usage data to use for forecasting.
     *
     * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples) section.
     */
    override suspend fun updateBudget(input: UpdateBudgetRequest): UpdateBudgetResponse {
        val op = SdkHttpOperation.build<UpdateBudgetRequest, UpdateBudgetResponse> {
            serializer = UpdateBudgetOperationSerializer()
            deserializer = UpdateBudgetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBudget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a budget action.
     */
    override suspend fun updateBudgetAction(input: UpdateBudgetActionRequest): UpdateBudgetActionResponse {
        val op = SdkHttpOperation.build<UpdateBudgetActionRequest, UpdateBudgetActionResponse> {
            serializer = UpdateBudgetActionOperationSerializer()
            deserializer = UpdateBudgetActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBudgetAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a notification.
     */
    override suspend fun updateNotification(input: UpdateNotificationRequest): UpdateNotificationResponse {
        val op = SdkHttpOperation.build<UpdateNotificationRequest, UpdateNotificationResponse> {
            serializer = UpdateNotificationOperationSerializer()
            deserializer = UpdateNotificationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNotification"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a subscriber.
     */
    override suspend fun updateSubscriber(input: UpdateSubscriberRequest): UpdateSubscriberResponse {
        val op = SdkHttpOperation.build<UpdateSubscriberRequest, UpdateSubscriberResponse> {
            serializer = UpdateSubscriberOperationSerializer()
            deserializer = UpdateSubscriberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSubscriber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSBudgetServiceGateway", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "budgets"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "budgets")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
