// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.budgets

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.budgets.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.budgets.model.*
import aws.sdk.kotlin.services.budgets.model.CreateBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.CreateBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.CreateBudgetRequest
import aws.sdk.kotlin.services.budgets.model.CreateBudgetResponse
import aws.sdk.kotlin.services.budgets.model.CreateNotificationRequest
import aws.sdk.kotlin.services.budgets.model.CreateNotificationResponse
import aws.sdk.kotlin.services.budgets.model.CreateSubscriberRequest
import aws.sdk.kotlin.services.budgets.model.CreateSubscriberResponse
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DeleteBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DeleteNotificationRequest
import aws.sdk.kotlin.services.budgets.model.DeleteNotificationResponse
import aws.sdk.kotlin.services.budgets.model.DeleteSubscriberRequest
import aws.sdk.kotlin.services.budgets.model.DeleteSubscriberResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionHistoriesRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionHistoriesResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForAccountRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForAccountResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetActionsForBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetNotificationsForAccountRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetNotificationsForAccountResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetPerformanceHistoryRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetPerformanceHistoryResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetsRequest
import aws.sdk.kotlin.services.budgets.model.DescribeBudgetsResponse
import aws.sdk.kotlin.services.budgets.model.DescribeNotificationsForBudgetRequest
import aws.sdk.kotlin.services.budgets.model.DescribeNotificationsForBudgetResponse
import aws.sdk.kotlin.services.budgets.model.DescribeSubscribersForNotificationRequest
import aws.sdk.kotlin.services.budgets.model.DescribeSubscribersForNotificationResponse
import aws.sdk.kotlin.services.budgets.model.ExecuteBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.ExecuteBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetActionRequest
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetActionResponse
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetRequest
import aws.sdk.kotlin.services.budgets.model.UpdateBudgetResponse
import aws.sdk.kotlin.services.budgets.model.UpdateNotificationRequest
import aws.sdk.kotlin.services.budgets.model.UpdateNotificationResponse
import aws.sdk.kotlin.services.budgets.model.UpdateSubscriberRequest
import aws.sdk.kotlin.services.budgets.model.UpdateSubscriberResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Use the Amazon Web Services Budgets API to plan your service usage, service costs, and instance reservations. This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for the Amazon Web Services Budgets feature.
 *
 * Budgets provide you with a way to see the following information:
 * + How close your plan is to your budgeted amount or to the free tier limits
 * + Your usage-to-date, including how much you've used of your Reserved Instances (RIs)
 * + Your current estimated charges from Amazon Web Services, and how much your predicted usage will accrue in charges by the end of the month
 * + How much of your budget has been used
 *
 * Amazon Web Services updates your budget status several times a day. Budgets track your unblended costs, subscriptions, refunds, and RIs. You can create the following types of budgets:
 * + **Cost budgets** - Plan how much you want to spend on a service.
 * + **Usage budgets** - Plan how much you want to use one or more services.
 * + **RI utilization budgets** - Define a utilization threshold, and receive alerts when your RI usage falls below that threshold. This lets you see if your RIs are unused or under-utilized.
 * + **RI coverage budgets** - Define a coverage threshold, and receive alerts when the number of your instance hours that are covered by RIs fall below that threshold. This lets you see how much of your instance usage is covered by a reservation.
 *
 * Service Endpoint
 *
 * The Amazon Web Services Budgets API provides the following endpoint:
 * + https://budgets.amazonaws.com
 *
 * For information about costs that are associated with the Amazon Web Services Budgets API, see [Amazon Web Services Cost Management Pricing](https://aws.amazon.com/aws-cost-management/pricing/).
 */
public interface BudgetsClient : SdkClient {

    override val serviceName: String
        get() = "Budgets"
    /**
     * BudgetsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): BudgetsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultBudgetsClient(config)
        }

        public operator fun invoke(config: Config): BudgetsClient = DefaultBudgetsClient(config)

        /**
         * Construct a [BudgetsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): BudgetsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultBudgetsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a budget and, if included, notifications and subscribers.
     *
     * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples) section.
     */
    public suspend fun createBudget(input: CreateBudgetRequest): CreateBudgetResponse

    /**
     * Creates a budget action.
     */
    public suspend fun createBudgetAction(input: CreateBudgetActionRequest): CreateBudgetActionResponse

    /**
     * Creates a notification. You must create the budget before you create the associated notification.
     */
    public suspend fun createNotification(input: CreateNotificationRequest): CreateNotificationResponse

    /**
     * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
     */
    public suspend fun createSubscriber(input: CreateSubscriberRequest): CreateSubscriberResponse

    /**
     * Deletes a budget. You can delete your budget at any time.
     *
     * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
     */
    public suspend fun deleteBudget(input: DeleteBudgetRequest): DeleteBudgetResponse

    /**
     * Deletes a budget action.
     */
    public suspend fun deleteBudgetAction(input: DeleteBudgetActionRequest): DeleteBudgetActionResponse

    /**
     * Deletes a notification.
     *
     * Deleting a notification also deletes the subscribers that are associated with the notification.
     */
    public suspend fun deleteNotification(input: DeleteNotificationRequest): DeleteNotificationResponse

    /**
     * Deletes a subscriber.
     *
     * Deleting the last subscriber to a notification also deletes the notification.
     */
    public suspend fun deleteSubscriber(input: DeleteSubscriberRequest): DeleteSubscriberResponse

    /**
     * Describes a budget.
     *
     * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples) section.
     */
    public suspend fun describeBudget(input: DescribeBudgetRequest): DescribeBudgetResponse

    /**
     * Describes a budget action detail.
     */
    public suspend fun describeBudgetAction(input: DescribeBudgetActionRequest): DescribeBudgetActionResponse

    /**
     * Describes a budget action history detail.
     */
    public suspend fun describeBudgetActionHistories(input: DescribeBudgetActionHistoriesRequest): DescribeBudgetActionHistoriesResponse

    /**
     * Describes all of the budget actions for an account.
     */
    public suspend fun describeBudgetActionsForAccount(input: DescribeBudgetActionsForAccountRequest): DescribeBudgetActionsForAccountResponse

    /**
     * Describes all of the budget actions for a budget.
     */
    public suspend fun describeBudgetActionsForBudget(input: DescribeBudgetActionsForBudgetRequest): DescribeBudgetActionsForBudgetResponse

    /**
     * Lists the budget names and notifications that are associated with an account.
     */
    public suspend fun describeBudgetNotificationsForAccount(input: DescribeBudgetNotificationsForAccountRequest): DescribeBudgetNotificationsForAccountResponse

    /**
     * Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets. Budget history isn't available for `ANNUAL` budgets.
     */
    public suspend fun describeBudgetPerformanceHistory(input: DescribeBudgetPerformanceHistoryRequest): DescribeBudgetPerformanceHistoryResponse

    /**
     * Lists the budgets that are associated with an account.
     *
     * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples) section.
     */
    public suspend fun describeBudgets(input: DescribeBudgetsRequest): DescribeBudgetsResponse

    /**
     * Lists the notifications that are associated with a budget.
     */
    public suspend fun describeNotificationsForBudget(input: DescribeNotificationsForBudgetRequest): DescribeNotificationsForBudgetResponse

    /**
     * Lists the subscribers that are associated with a notification.
     */
    public suspend fun describeSubscribersForNotification(input: DescribeSubscribersForNotificationRequest): DescribeSubscribersForNotificationResponse

    /**
     * Executes a budget action.
     */
    public suspend fun executeBudgetAction(input: ExecuteBudgetActionRequest): ExecuteBudgetActionResponse

    /**
     * Updates a budget. You can change every part of a budget except for the `budgetName` and the `calculatedSpend`. When you modify a budget, the `calculatedSpend` drops to zero until Amazon Web Services has new usage data to use for forecasting.
     *
     * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples) section.
     */
    public suspend fun updateBudget(input: UpdateBudgetRequest): UpdateBudgetResponse

    /**
     * Updates a budget action.
     */
    public suspend fun updateBudgetAction(input: UpdateBudgetActionRequest): UpdateBudgetActionResponse

    /**
     * Updates a notification.
     */
    public suspend fun updateNotification(input: UpdateNotificationRequest): UpdateNotificationResponse

    /**
     * Updates a subscriber.
     */
    public suspend fun updateSubscriber(input: UpdateSubscriberRequest): UpdateSubscriberResponse
}

/**
 * Creates a budget and, if included, notifications and subscribers.
 *
 * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples) section.
 */
public suspend inline fun BudgetsClient.createBudget(crossinline block: CreateBudgetRequest.Builder.() -> Unit): CreateBudgetResponse = createBudget(CreateBudgetRequest.Builder().apply(block).build())

/**
 * Creates a budget action.
 */
public suspend inline fun BudgetsClient.createBudgetAction(crossinline block: CreateBudgetActionRequest.Builder.() -> Unit): CreateBudgetActionResponse = createBudgetAction(CreateBudgetActionRequest.Builder().apply(block).build())

/**
 * Creates a notification. You must create the budget before you create the associated notification.
 */
public suspend inline fun BudgetsClient.createNotification(crossinline block: CreateNotificationRequest.Builder.() -> Unit): CreateNotificationResponse = createNotification(CreateNotificationRequest.Builder().apply(block).build())

/**
 * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
 */
public suspend inline fun BudgetsClient.createSubscriber(crossinline block: CreateSubscriberRequest.Builder.() -> Unit): CreateSubscriberResponse = createSubscriber(CreateSubscriberRequest.Builder().apply(block).build())

/**
 * Deletes a budget. You can delete your budget at any time.
 *
 * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
 */
public suspend inline fun BudgetsClient.deleteBudget(crossinline block: DeleteBudgetRequest.Builder.() -> Unit): DeleteBudgetResponse = deleteBudget(DeleteBudgetRequest.Builder().apply(block).build())

/**
 * Deletes a budget action.
 */
public suspend inline fun BudgetsClient.deleteBudgetAction(crossinline block: DeleteBudgetActionRequest.Builder.() -> Unit): DeleteBudgetActionResponse = deleteBudgetAction(DeleteBudgetActionRequest.Builder().apply(block).build())

/**
 * Deletes a notification.
 *
 * Deleting a notification also deletes the subscribers that are associated with the notification.
 */
public suspend inline fun BudgetsClient.deleteNotification(crossinline block: DeleteNotificationRequest.Builder.() -> Unit): DeleteNotificationResponse = deleteNotification(DeleteNotificationRequest.Builder().apply(block).build())

/**
 * Deletes a subscriber.
 *
 * Deleting the last subscriber to a notification also deletes the notification.
 */
public suspend inline fun BudgetsClient.deleteSubscriber(crossinline block: DeleteSubscriberRequest.Builder.() -> Unit): DeleteSubscriberResponse = deleteSubscriber(DeleteSubscriberRequest.Builder().apply(block).build())

/**
 * Describes a budget.
 *
 * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples) section.
 */
public suspend inline fun BudgetsClient.describeBudget(crossinline block: DescribeBudgetRequest.Builder.() -> Unit): DescribeBudgetResponse = describeBudget(DescribeBudgetRequest.Builder().apply(block).build())

/**
 * Describes a budget action detail.
 */
public suspend inline fun BudgetsClient.describeBudgetAction(crossinline block: DescribeBudgetActionRequest.Builder.() -> Unit): DescribeBudgetActionResponse = describeBudgetAction(DescribeBudgetActionRequest.Builder().apply(block).build())

/**
 * Describes a budget action history detail.
 */
public suspend inline fun BudgetsClient.describeBudgetActionHistories(crossinline block: DescribeBudgetActionHistoriesRequest.Builder.() -> Unit): DescribeBudgetActionHistoriesResponse = describeBudgetActionHistories(DescribeBudgetActionHistoriesRequest.Builder().apply(block).build())

/**
 * Describes all of the budget actions for an account.
 */
public suspend inline fun BudgetsClient.describeBudgetActionsForAccount(crossinline block: DescribeBudgetActionsForAccountRequest.Builder.() -> Unit): DescribeBudgetActionsForAccountResponse = describeBudgetActionsForAccount(DescribeBudgetActionsForAccountRequest.Builder().apply(block).build())

/**
 * Describes all of the budget actions for a budget.
 */
public suspend inline fun BudgetsClient.describeBudgetActionsForBudget(crossinline block: DescribeBudgetActionsForBudgetRequest.Builder.() -> Unit): DescribeBudgetActionsForBudgetResponse = describeBudgetActionsForBudget(DescribeBudgetActionsForBudgetRequest.Builder().apply(block).build())

/**
 * Lists the budget names and notifications that are associated with an account.
 */
public suspend inline fun BudgetsClient.describeBudgetNotificationsForAccount(crossinline block: DescribeBudgetNotificationsForAccountRequest.Builder.() -> Unit): DescribeBudgetNotificationsForAccountResponse = describeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountRequest.Builder().apply(block).build())

/**
 * Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets. Budget history isn't available for `ANNUAL` budgets.
 */
public suspend inline fun BudgetsClient.describeBudgetPerformanceHistory(crossinline block: DescribeBudgetPerformanceHistoryRequest.Builder.() -> Unit): DescribeBudgetPerformanceHistoryResponse = describeBudgetPerformanceHistory(DescribeBudgetPerformanceHistoryRequest.Builder().apply(block).build())

/**
 * Lists the budgets that are associated with an account.
 *
 * The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples) section.
 */
public suspend inline fun BudgetsClient.describeBudgets(crossinline block: DescribeBudgetsRequest.Builder.() -> Unit): DescribeBudgetsResponse = describeBudgets(DescribeBudgetsRequest.Builder().apply(block).build())

/**
 * Lists the notifications that are associated with a budget.
 */
public suspend inline fun BudgetsClient.describeNotificationsForBudget(crossinline block: DescribeNotificationsForBudgetRequest.Builder.() -> Unit): DescribeNotificationsForBudgetResponse = describeNotificationsForBudget(DescribeNotificationsForBudgetRequest.Builder().apply(block).build())

/**
 * Lists the subscribers that are associated with a notification.
 */
public suspend inline fun BudgetsClient.describeSubscribersForNotification(crossinline block: DescribeSubscribersForNotificationRequest.Builder.() -> Unit): DescribeSubscribersForNotificationResponse = describeSubscribersForNotification(DescribeSubscribersForNotificationRequest.Builder().apply(block).build())

/**
 * Executes a budget action.
 */
public suspend inline fun BudgetsClient.executeBudgetAction(crossinline block: ExecuteBudgetActionRequest.Builder.() -> Unit): ExecuteBudgetActionResponse = executeBudgetAction(ExecuteBudgetActionRequest.Builder().apply(block).build())

/**
 * Updates a budget. You can change every part of a budget except for the `budgetName` and the `calculatedSpend`. When you modify a budget, the `calculatedSpend` drops to zero until Amazon Web Services has new usage data to use for forecasting.
 *
 * Only one of `BudgetLimit` or `PlannedBudgetLimits` can be present in the syntax at one time. Use the syntax that matches your case. The Request Syntax section shows the `BudgetLimit` syntax. For `PlannedBudgetLimits`, see the [Examples](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples) section.
 */
public suspend inline fun BudgetsClient.updateBudget(crossinline block: UpdateBudgetRequest.Builder.() -> Unit): UpdateBudgetResponse = updateBudget(UpdateBudgetRequest.Builder().apply(block).build())

/**
 * Updates a budget action.
 */
public suspend inline fun BudgetsClient.updateBudgetAction(crossinline block: UpdateBudgetActionRequest.Builder.() -> Unit): UpdateBudgetActionResponse = updateBudgetAction(UpdateBudgetActionRequest.Builder().apply(block).build())

/**
 * Updates a notification.
 */
public suspend inline fun BudgetsClient.updateNotification(crossinline block: UpdateNotificationRequest.Builder.() -> Unit): UpdateNotificationResponse = updateNotification(UpdateNotificationRequest.Builder().apply(block).build())

/**
 * Updates a subscriber.
 */
public suspend inline fun BudgetsClient.updateSubscriber(crossinline block: UpdateSubscriberRequest.Builder.() -> Unit): UpdateSubscriberResponse = updateSubscriber(UpdateSubscriberRequest.Builder().apply(block).build())
