// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.serde

import aws.sdk.kotlin.services.braket.model.Association
import aws.sdk.kotlin.services.braket.model.BraketException
import aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse
import aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo
import aws.sdk.kotlin.services.braket.model.QuantumTaskStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetQuantumTaskOperationDeserializer: HttpDeserializer.NonStreaming<GetQuantumTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetQuantumTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetQuantumTaskError(context, call, payload)
        }
        val builder = GetQuantumTaskResponse.Builder()

        if (payload != null) {
            deserializeGetQuantumTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetQuantumTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BraketException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BraketException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQuantumTaskOperationBody(builder: GetQuantumTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("associations"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceArn"))
    val DEVICEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceParameters"))
    val ENDEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endedAt"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val OUTPUTS3BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputS3Bucket"))
    val OUTPUTS3DIRECTORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputS3Directory"))
    val QUANTUMTASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("quantumTaskArn"))
    val QUEUEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("queueInfo"))
    val SHOTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("shots"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATIONS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DEVICEARN_DESCRIPTOR)
        field(DEVICEPARAMETERS_DESCRIPTOR)
        field(ENDEDAT_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(OUTPUTS3BUCKET_DESCRIPTOR)
        field(OUTPUTS3DIRECTORY_DESCRIPTOR)
        field(QUANTUMTASKARN_DESCRIPTOR)
        field(QUEUEINFO_DESCRIPTOR)
        field(SHOTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATIONS_DESCRIPTOR.index -> builder.associations =
                    deserializer.deserializeList(ASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Association>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                DEVICEARN_DESCRIPTOR.index -> builder.deviceArn = deserializeString()
                DEVICEPARAMETERS_DESCRIPTOR.index -> builder.deviceParameters = deserializeString()
                ENDEDAT_DESCRIPTOR.index -> builder.endedAt = deserializeInstant(TimestampFormat.ISO_8601)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                OUTPUTS3BUCKET_DESCRIPTOR.index -> builder.outputS3Bucket = deserializeString()
                OUTPUTS3DIRECTORY_DESCRIPTOR.index -> builder.outputS3Directory = deserializeString()
                QUANTUMTASKARN_DESCRIPTOR.index -> builder.quantumTaskArn = deserializeString()
                QUEUEINFO_DESCRIPTOR.index -> builder.queueInfo = deserializeQuantumTaskQueueInfoDocument(deserializer)
                SHOTS_DESCRIPTOR.index -> builder.shots = deserializeLong()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { QuantumTaskStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
