// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.serde

import aws.sdk.kotlin.services.braket.model.AlgorithmSpecification
import aws.sdk.kotlin.services.braket.model.Association
import aws.sdk.kotlin.services.braket.model.BraketException
import aws.sdk.kotlin.services.braket.model.DeviceConfig
import aws.sdk.kotlin.services.braket.model.GetJobResponse
import aws.sdk.kotlin.services.braket.model.HybridJobQueueInfo
import aws.sdk.kotlin.services.braket.model.InputFileConfig
import aws.sdk.kotlin.services.braket.model.InstanceConfig
import aws.sdk.kotlin.services.braket.model.JobCheckpointConfig
import aws.sdk.kotlin.services.braket.model.JobEventDetails
import aws.sdk.kotlin.services.braket.model.JobOutputDataConfig
import aws.sdk.kotlin.services.braket.model.JobPrimaryStatus
import aws.sdk.kotlin.services.braket.model.JobStoppingCondition
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetJobOperationDeserializer: HttpDeserializer.NonStreaming<GetJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetJobError(context, call, payload)
        }
        val builder = GetJobResponse.Builder()

        if (payload != null) {
            deserializeGetJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BraketException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BraketException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetJobOperationBody(builder: GetJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALGORITHMSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("algorithmSpecification"))
    val ASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("associations"))
    val BILLABLEDURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("billableDuration"))
    val CHECKPOINTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("checkpointConfig"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEVICECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deviceConfig"))
    val ENDEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endedAt"))
    val EVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("events"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("hyperParameters"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputDataConfig"))
    val INSTANCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("instanceConfig"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val QUEUEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("queueInfo"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stoppingCondition"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMSPECIFICATION_DESCRIPTOR)
        field(ASSOCIATIONS_DESCRIPTOR)
        field(BILLABLEDURATION_DESCRIPTOR)
        field(CHECKPOINTCONFIG_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DEVICECONFIG_DESCRIPTOR)
        field(ENDEDAT_DESCRIPTOR)
        field(EVENTS_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(INSTANCECONFIG_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(QUEUEINFO_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STARTEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALGORITHMSPECIFICATION_DESCRIPTOR.index -> builder.algorithmSpecification = deserializeAlgorithmSpecificationDocument(deserializer)
                ASSOCIATIONS_DESCRIPTOR.index -> builder.associations =
                    deserializer.deserializeList(ASSOCIATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Association>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BILLABLEDURATION_DESCRIPTOR.index -> builder.billableDuration = deserializeInt()
                CHECKPOINTCONFIG_DESCRIPTOR.index -> builder.checkpointConfig = deserializeJobCheckpointConfigDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                DEVICECONFIG_DESCRIPTOR.index -> builder.deviceConfig = deserializeDeviceConfigDocument(deserializer)
                ENDEDAT_DESCRIPTOR.index -> builder.endedAt = deserializeInstant(TimestampFormat.ISO_8601)
                EVENTS_DESCRIPTOR.index -> builder.events =
                    deserializer.deserializeList(EVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<JobEventDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeJobEventDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HYPERPARAMETERS_DESCRIPTOR.index -> builder.hyperParameters =
                    deserializer.deserializeMap(HYPERPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                INPUTDATACONFIG_DESCRIPTOR.index -> builder.inputDataConfig =
                    deserializer.deserializeList(INPUTDATACONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<InputFileConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInputFileConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INSTANCECONFIG_DESCRIPTOR.index -> builder.instanceConfig = deserializeInstanceConfigDocument(deserializer)
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeJobOutputDataConfigDocument(deserializer)
                QUEUEINFO_DESCRIPTOR.index -> builder.queueInfo = deserializeHybridJobQueueInfoDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STARTEDAT_DESCRIPTOR.index -> builder.startedAt = deserializeInstant(TimestampFormat.ISO_8601)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { JobPrimaryStatus.fromValue(it) }
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeJobStoppingConditionDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
