// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.serde

import aws.sdk.kotlin.services.braket.model.BraketException
import aws.sdk.kotlin.services.braket.model.DeviceQueueInfo
import aws.sdk.kotlin.services.braket.model.DeviceStatus
import aws.sdk.kotlin.services.braket.model.DeviceType
import aws.sdk.kotlin.services.braket.model.GetDeviceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetDeviceOperationDeserializer: HttpDeserializer.NonStreaming<GetDeviceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDeviceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDeviceError(context, call, payload)
        }
        val builder = GetDeviceResponse.Builder()

        if (payload != null) {
            deserializeGetDeviceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDeviceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BraketException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BraketException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeviceOperationBody(builder: GetDeviceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceArn"))
    val DEVICECAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceCapabilities"))
    val DEVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceName"))
    val DEVICEQUEUEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deviceQueueInfo"))
    val DEVICESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceStatus"))
    val DEVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceType"))
    val PROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("providerName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICEARN_DESCRIPTOR)
        field(DEVICECAPABILITIES_DESCRIPTOR)
        field(DEVICENAME_DESCRIPTOR)
        field(DEVICEQUEUEINFO_DESCRIPTOR)
        field(DEVICESTATUS_DESCRIPTOR)
        field(DEVICETYPE_DESCRIPTOR)
        field(PROVIDERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICEARN_DESCRIPTOR.index -> builder.deviceArn = deserializeString()
                DEVICECAPABILITIES_DESCRIPTOR.index -> builder.deviceCapabilities = deserializeString()
                DEVICENAME_DESCRIPTOR.index -> builder.deviceName = deserializeString()
                DEVICEQUEUEINFO_DESCRIPTOR.index -> builder.deviceQueueInfo =
                    deserializer.deserializeList(DEVICEQUEUEINFO_DESCRIPTOR) {
                        val col0 = mutableListOf<DeviceQueueInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeviceQueueInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEVICESTATUS_DESCRIPTOR.index -> builder.deviceStatus = deserializeString().let { DeviceStatus.fromValue(it) }
                DEVICETYPE_DESCRIPTOR.index -> builder.deviceType = deserializeString().let { DeviceType.fromValue(it) }
                PROVIDERNAME_DESCRIPTOR.index -> builder.providerName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
