// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.serde

import aws.sdk.kotlin.services.braket.model.AlgorithmSpecification
import aws.sdk.kotlin.services.braket.model.Association
import aws.sdk.kotlin.services.braket.model.CreateJobRequest
import aws.sdk.kotlin.services.braket.model.DeviceConfig
import aws.sdk.kotlin.services.braket.model.InputFileConfig
import aws.sdk.kotlin.services.braket.model.InstanceConfig
import aws.sdk.kotlin.services.braket.model.JobCheckpointConfig
import aws.sdk.kotlin.services.braket.model.JobOutputDataConfig
import aws.sdk.kotlin.services.braket.model.JobStoppingCondition
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateJobOperationSerializer: HttpSerializer.NonStreaming<CreateJobRequest> {
    override fun serialize(context: ExecutionContext, input: CreateJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/job"
        }

        val payload = serializeCreateJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateJobOperationBody(context: ExecutionContext, input: CreateJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALGORITHMSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("algorithmSpecification"))
    val ASSOCIATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("associations"))
    val CHECKPOINTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("checkpointConfig"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DEVICECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deviceConfig"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("hyperParameters"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputDataConfig"))
    val INSTANCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("instanceConfig"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stoppingCondition"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMSPECIFICATION_DESCRIPTOR)
        field(ASSOCIATIONS_DESCRIPTOR)
        field(CHECKPOINTCONFIG_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DEVICECONFIG_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(INSTANCECONFIG_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.algorithmSpecification?.let { field(ALGORITHMSPECIFICATION_DESCRIPTOR, it, ::serializeAlgorithmSpecificationDocument) }
        if (input.associations != null) {
            listField(ASSOCIATIONS_DESCRIPTOR) {
                for (el0 in input.associations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssociationDocument))
                }
            }
        }
        input.checkpointConfig?.let { field(CHECKPOINTCONFIG_DESCRIPTOR, it, ::serializeJobCheckpointConfigDocument) }
        field(CLIENTTOKEN_DESCRIPTOR, input.clientToken) ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.deviceConfig?.let { field(DEVICECONFIG_DESCRIPTOR, it, ::serializeDeviceConfigDocument) }
        if (input.hyperParameters != null) {
            mapField(HYPERPARAMETERS_DESCRIPTOR) {
                input.hyperParameters.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        if (input.inputDataConfig != null) {
            listField(INPUTDATACONFIG_DESCRIPTOR) {
                for (el0 in input.inputDataConfig) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputFileConfigDocument))
                }
            }
        }
        input.instanceConfig?.let { field(INSTANCECONFIG_DESCRIPTOR, it, ::serializeInstanceConfigDocument) }
        field(JOBNAME_DESCRIPTOR, input.jobName)
        input.outputDataConfig?.let { field(OUTPUTDATACONFIG_DESCRIPTOR, it, ::serializeJobOutputDataConfigDocument) }
        field(ROLEARN_DESCRIPTOR, input.roleArn)
        input.stoppingCondition?.let { field(STOPPINGCONDITION_DESCRIPTOR, it, ::serializeJobStoppingConditionDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
