// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.paginators

import aws.sdk.kotlin.services.braket.BraketClient
import aws.sdk.kotlin.services.braket.model.DeviceSummary
import aws.sdk.kotlin.services.braket.model.JobSummary
import aws.sdk.kotlin.services.braket.model.QuantumTaskSummary
import aws.sdk.kotlin.services.braket.model.SearchDevicesRequest
import aws.sdk.kotlin.services.braket.model.SearchDevicesResponse
import aws.sdk.kotlin.services.braket.model.SearchJobsRequest
import aws.sdk.kotlin.services.braket.model.SearchJobsResponse
import aws.sdk.kotlin.services.braket.model.SearchQuantumTasksRequest
import aws.sdk.kotlin.services.braket.model.SearchQuantumTasksResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [SearchDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchDevicesResponse]
 */
public fun BraketClient.searchDevicesPaginated(initialRequest: SearchDevicesRequest): Flow<SearchDevicesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchDevicesPaginated.searchDevices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchDevicesResponse]
 */
public fun BraketClient.searchDevicesPaginated(block: SearchDevicesRequest.Builder.() -> Unit): Flow<SearchDevicesResponse> =
    searchDevicesPaginated(SearchDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchDevicesPaginated]
 * to access the nested member [DeviceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeviceSummary]
 */
@JvmName("searchDevicesResponseDeviceSummary")
public fun Flow<SearchDevicesResponse>.devices(): Flow<DeviceSummary> =
    transform() { response ->
        response.devices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchJobsResponse]
 */
public fun BraketClient.searchJobsPaginated(initialRequest: SearchJobsRequest): Flow<SearchJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchJobsPaginated.searchJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchJobsResponse]
 */
public fun BraketClient.searchJobsPaginated(block: SearchJobsRequest.Builder.() -> Unit): Flow<SearchJobsResponse> =
    searchJobsPaginated(SearchJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchJobsPaginated]
 * to access the nested member [JobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobSummary]
 */
@JvmName("searchJobsResponseJobSummary")
public fun Flow<SearchJobsResponse>.jobs(): Flow<JobSummary> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchQuantumTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchQuantumTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchQuantumTasksResponse]
 */
public fun BraketClient.searchQuantumTasksPaginated(initialRequest: SearchQuantumTasksRequest): Flow<SearchQuantumTasksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchQuantumTasksPaginated.searchQuantumTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchQuantumTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchQuantumTasksResponse]
 */
public fun BraketClient.searchQuantumTasksPaginated(block: SearchQuantumTasksRequest.Builder.() -> Unit): Flow<SearchQuantumTasksResponse> =
    searchQuantumTasksPaginated(SearchQuantumTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchQuantumTasksPaginated]
 * to access the nested member [QuantumTaskSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QuantumTaskSummary]
 */
@JvmName("searchQuantumTasksResponseQuantumTaskSummary")
public fun Flow<SearchQuantumTasksResponse>.quantumTasks(): Flow<QuantumTaskSummary> =
    transform() { response ->
        response.quantumTasks?.forEach {
            emit(it)
        }
    }
