// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the Python scripts used for entry and by an Amazon Braket job.
 */
public class ScriptModeConfig private constructor(builder: Builder) {
    /**
     * The type of compression used by the Python scripts for an Amazon Braket job.
     */
    public val compressionType: aws.sdk.kotlin.services.braket.model.CompressionType? = builder.compressionType
    /**
     * The path to the Python script that serves as the entry point for an Amazon Braket job.
     */
    public val entryPoint: kotlin.String = requireNotNull(builder.entryPoint) { "A non-null value must be provided for entryPoint" }
    /**
     * The URI that specifies the S3 path to the Python script module that contains the training script used by an Amazon Braket job.
     */
    public val s3Uri: kotlin.String = requireNotNull(builder.s3Uri) { "A non-null value must be provided for s3Uri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.ScriptModeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScriptModeConfig(")
        append("compressionType=$compressionType,")
        append("entryPoint=$entryPoint,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compressionType?.hashCode() ?: 0
        result = 31 * result + (entryPoint.hashCode())
        result = 31 * result + (s3Uri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScriptModeConfig

        if (compressionType != other.compressionType) return false
        if (entryPoint != other.entryPoint) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.ScriptModeConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of compression used by the Python scripts for an Amazon Braket job.
         */
        public var compressionType: aws.sdk.kotlin.services.braket.model.CompressionType? = null
        /**
         * The path to the Python script that serves as the entry point for an Amazon Braket job.
         */
        public var entryPoint: kotlin.String? = null
        /**
         * The URI that specifies the S3 path to the Python script module that contains the training script used by an Amazon Braket job.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.ScriptModeConfig) : this() {
            this.compressionType = x.compressionType
            this.entryPoint = x.entryPoint
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.ScriptModeConfig = ScriptModeConfig(this)

        internal fun correctErrors(): Builder {
            if (entryPoint == null) entryPoint = ""
            if (s3Uri == null) s3Uri = ""
            return this
        }
    }
}
