// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Includes information about a quantum task.
 */
public class QuantumTaskSummary private constructor(builder: Builder) {
    /**
     * The time at which the task was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The ARN of the device the task ran on.
     */
    public val deviceArn: kotlin.String = requireNotNull(builder.deviceArn) { "A non-null value must be provided for deviceArn" }
    /**
     * The time at which the task finished.
     */
    public val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * The S3 bucket where the task result file is stored..
     */
    public val outputS3Bucket: kotlin.String = requireNotNull(builder.outputS3Bucket) { "A non-null value must be provided for outputS3Bucket" }
    /**
     * The folder in the S3 bucket where the task result file is stored.
     */
    public val outputS3Directory: kotlin.String = requireNotNull(builder.outputS3Directory) { "A non-null value must be provided for outputS3Directory" }
    /**
     * The ARN of the task.
     */
    public val quantumTaskArn: kotlin.String = requireNotNull(builder.quantumTaskArn) { "A non-null value must be provided for quantumTaskArn" }
    /**
     * The shots used for the task.
     */
    public val shots: kotlin.Long = requireNotNull(builder.shots) { "A non-null value must be provided for shots" }
    /**
     * The status of the task.
     */
    public val status: aws.sdk.kotlin.services.braket.model.QuantumTaskStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Displays the key, value pairs of tags associated with this quantum task.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.QuantumTaskSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuantumTaskSummary(")
        append("createdAt=$createdAt,")
        append("deviceArn=$deviceArn,")
        append("endedAt=$endedAt,")
        append("outputS3Bucket=$outputS3Bucket,")
        append("outputS3Directory=$outputS3Directory,")
        append("quantumTaskArn=$quantumTaskArn,")
        append("shots=$shots,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (deviceArn.hashCode())
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (outputS3Bucket.hashCode())
        result = 31 * result + (outputS3Directory.hashCode())
        result = 31 * result + (quantumTaskArn.hashCode())
        result = 31 * result + (shots.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuantumTaskSummary

        if (createdAt != other.createdAt) return false
        if (deviceArn != other.deviceArn) return false
        if (endedAt != other.endedAt) return false
        if (outputS3Bucket != other.outputS3Bucket) return false
        if (outputS3Directory != other.outputS3Directory) return false
        if (quantumTaskArn != other.quantumTaskArn) return false
        if (shots != other.shots) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.QuantumTaskSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time at which the task was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the device the task ran on.
         */
        public var deviceArn: kotlin.String? = null
        /**
         * The time at which the task finished.
         */
        public var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The S3 bucket where the task result file is stored..
         */
        public var outputS3Bucket: kotlin.String? = null
        /**
         * The folder in the S3 bucket where the task result file is stored.
         */
        public var outputS3Directory: kotlin.String? = null
        /**
         * The ARN of the task.
         */
        public var quantumTaskArn: kotlin.String? = null
        /**
         * The shots used for the task.
         */
        public var shots: kotlin.Long? = null
        /**
         * The status of the task.
         */
        public var status: aws.sdk.kotlin.services.braket.model.QuantumTaskStatus? = null
        /**
         * Displays the key, value pairs of tags associated with this quantum task.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.QuantumTaskSummary) : this() {
            this.createdAt = x.createdAt
            this.deviceArn = x.deviceArn
            this.endedAt = x.endedAt
            this.outputS3Bucket = x.outputS3Bucket
            this.outputS3Directory = x.outputS3Directory
            this.quantumTaskArn = x.quantumTaskArn
            this.shots = x.shots
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.QuantumTaskSummary = QuantumTaskSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (deviceArn == null) deviceArn = ""
            if (outputS3Bucket == null) outputS3Bucket = ""
            if (outputS3Directory == null) outputS3Directory = ""
            if (quantumTaskArn == null) quantumTaskArn = ""
            if (shots == null) shots = 0L
            if (status == null) status = QuantumTaskStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
