// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the queue for the specified quantum task.
 */
public class QuantumTaskQueueInfo private constructor(builder: Builder) {
    /**
     * Optional. Provides more information about the queue position. For example, if the task is complete and no longer in the queue, the message field contains that information.
     */
    public val message: kotlin.String? = builder.message
    /**
     * Current position of the task in the quantum tasks queue.
     */
    public val position: kotlin.String = requireNotNull(builder.position) { "A non-null value must be provided for position" }
    /**
     * The name of the queue.
     */
    public val queue: aws.sdk.kotlin.services.braket.model.QueueName = requireNotNull(builder.queue) { "A non-null value must be provided for queue" }
    /**
     * Optional. Specifies the priority of the queue. Quantum tasks in a priority queue are processed before the tasks in a normal queue.
     */
    public val queuePriority: aws.sdk.kotlin.services.braket.model.QueuePriority? = builder.queuePriority

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuantumTaskQueueInfo(")
        append("message=$message,")
        append("position=$position,")
        append("queue=$queue,")
        append("queuePriority=$queuePriority")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (position.hashCode())
        result = 31 * result + (queue.hashCode())
        result = 31 * result + (queuePriority?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuantumTaskQueueInfo

        if (message != other.message) return false
        if (position != other.position) return false
        if (queue != other.queue) return false
        if (queuePriority != other.queuePriority) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional. Provides more information about the queue position. For example, if the task is complete and no longer in the queue, the message field contains that information.
         */
        public var message: kotlin.String? = null
        /**
         * Current position of the task in the quantum tasks queue.
         */
        public var position: kotlin.String? = null
        /**
         * The name of the queue.
         */
        public var queue: aws.sdk.kotlin.services.braket.model.QueueName? = null
        /**
         * Optional. Specifies the priority of the queue. Quantum tasks in a priority queue are processed before the tasks in a normal queue.
         */
        public var queuePriority: aws.sdk.kotlin.services.braket.model.QueuePriority? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo) : this() {
            this.message = x.message
            this.position = x.position
            this.queue = x.queue
            this.queuePriority = x.queuePriority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo = QuantumTaskQueueInfo(this)

        internal fun correctErrors(): Builder {
            if (position == null) position = ""
            if (queue == null) queue = QueueName.SdkUnknown("no value provided")
            return this
        }
    }
}
