// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about an Amazon Braket job.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The date and time that the Amazon Braket job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Provides summary information about the primary device used by an Amazon Braket job.
     */
    public val device: kotlin.String = requireNotNull(builder.device) { "A non-null value must be provided for device" }
    /**
     * The date and time that the Amazon Braket job ended.
     */
    public val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * The ARN of the Amazon Braket job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The name of the Amazon Braket job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * The date and time that the Amazon Braket job was started.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the Amazon Braket job.
     */
    public val status: aws.sdk.kotlin.services.braket.model.JobPrimaryStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("createdAt=$createdAt,")
        append("device=$device,")
        append("endedAt=$endedAt,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (device.hashCode())
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (createdAt != other.createdAt) return false
        if (device != other.device) return false
        if (endedAt != other.endedAt) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.JobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that the Amazon Braket job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides summary information about the primary device used by an Amazon Braket job.
         */
        public var device: kotlin.String? = null
        /**
         * The date and time that the Amazon Braket job ended.
         */
        public var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the Amazon Braket job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The name of the Amazon Braket job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The date and time that the Amazon Braket job was started.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the Amazon Braket job.
         */
        public var status: aws.sdk.kotlin.services.braket.model.JobPrimaryStatus? = null
        /**
         * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.JobSummary) : this() {
            this.createdAt = x.createdAt
            this.device = x.device
            this.endedAt = x.endedAt
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.startedAt = x.startedAt
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.JobSummary = JobSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (device == null) device = ""
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (status == null) status = JobPrimaryStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
