// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the path to the S3 location where you want to store job artifacts and the encryption key used to store them.
 */
public class JobOutputDataConfig private constructor(builder: Builder) {
    /**
     * The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt the job training artifacts at rest using Amazon S3 server-side encryption.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Identifies the S3 path where you want Amazon Braket to store the job training artifacts. For example, `s3://bucket-name/key-name-prefix`.
     */
    public val s3Path: kotlin.String = requireNotNull(builder.s3Path) { "A non-null value must be provided for s3Path" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.JobOutputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobOutputDataConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("s3Path=$s3Path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (s3Path.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobOutputDataConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (s3Path != other.s3Path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.JobOutputDataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The AWS Key Management Service (AWS KMS) key that Amazon Braket uses to encrypt the job training artifacts at rest using Amazon S3 server-side encryption.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Identifies the S3 path where you want Amazon Braket to store the job training artifacts. For example, `s3://bucket-name/key-name-prefix`.
         */
        public var s3Path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.s3Path = x.s3Path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.JobOutputDataConfig = JobOutputDataConfig(this)

        internal fun correctErrors(): Builder {
            if (s3Path == null) s3Path = ""
            return this
        }
    }
}
