// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures the resource instances to use while running the Amazon Braket hybrid job on Amazon Braket.
 */
public class InstanceConfig private constructor(builder: Builder) {
    /**
     * Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket. The default value is 1.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Configures the type resource instances to use while running an Amazon Braket hybrid job.
     */
    public val instanceType: aws.sdk.kotlin.services.braket.model.InstanceType = requireNotNull(builder.instanceType) { "A non-null value must be provided for instanceType" }
    /**
     * The size of the storage volume, in GB, that user wants to provision.
     */
    public val volumeSizeInGb: kotlin.Int = requireNotNull(builder.volumeSizeInGb) { "A non-null value must be provided for volumeSizeInGb" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.InstanceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceConfig(")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceCount ?: 0
        result = 31 * result + (instanceType.hashCode())
        result = 31 * result + (volumeSizeInGb)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceConfig

        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.InstanceConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket. The default value is 1.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * Configures the type resource instances to use while running an Amazon Braket hybrid job.
         */
        public var instanceType: aws.sdk.kotlin.services.braket.model.InstanceType? = null
        /**
         * The size of the storage volume, in GB, that user wants to provision.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.InstanceConfig) : this() {
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.InstanceConfig = InstanceConfig(this)

        internal fun correctErrors(): Builder {
            if (instanceType == null) instanceType = InstanceType.SdkUnknown("no value provided")
            if (volumeSizeInGb == null) volumeSizeInGb = 0
            return this
        }
    }
}
