// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of parameters that specify the input channels, type of input data, and where it is located.
 */
public class InputFileConfig private constructor(builder: Builder) {
    /**
     * A named input source that an Amazon Braket job can consume.
     */
    public val channelName: kotlin.String = requireNotNull(builder.channelName) { "A non-null value must be provided for channelName" }
    /**
     * The MIME type of the data.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The location of the channel data.
     */
    public val dataSource: aws.sdk.kotlin.services.braket.model.DataSource? = builder.dataSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.InputFileConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputFileConfig(")
        append("channelName=$channelName,")
        append("contentType=$contentType,")
        append("dataSource=$dataSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName.hashCode()
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputFileConfig

        if (channelName != other.channelName) return false
        if (contentType != other.contentType) return false
        if (dataSource != other.dataSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.InputFileConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A named input source that an Amazon Braket job can consume.
         */
        public var channelName: kotlin.String? = null
        /**
         * The MIME type of the data.
         */
        public var contentType: kotlin.String? = null
        /**
         * The location of the channel data.
         */
        public var dataSource: aws.sdk.kotlin.services.braket.model.DataSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.InputFileConfig) : this() {
            this.channelName = x.channelName
            this.contentType = x.contentType
            this.dataSource = x.dataSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.InputFileConfig = InputFileConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.DataSource] inside the given [block]
         */
        public fun dataSource(block: aws.sdk.kotlin.services.braket.model.DataSource.Builder.() -> kotlin.Unit) {
            this.dataSource = aws.sdk.kotlin.services.braket.model.DataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (channelName == null) channelName = ""
            return this
        }
    }
}
