// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetQuantumTaskResponse private constructor(builder: Builder) {
    /**
     * The list of Amazon Braket resources associated with the quantum task.
     */
    public val associations: List<Association>? = builder.associations
    /**
     * The time at which the task was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The ARN of the device the task was run on.
     */
    public val deviceArn: kotlin.String = requireNotNull(builder.deviceArn) { "A non-null value must be provided for deviceArn" }
    /**
     * The parameters for the device on which the task ran.
     */
    public val deviceParameters: kotlin.String = requireNotNull(builder.deviceParameters) { "A non-null value must be provided for deviceParameters" }
    /**
     * The time at which the task ended.
     */
    public val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * The reason that a task failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ARN of the Amazon Braket job associated with the quantum task.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The S3 bucket where task results are stored.
     */
    public val outputS3Bucket: kotlin.String = requireNotNull(builder.outputS3Bucket) { "A non-null value must be provided for outputS3Bucket" }
    /**
     * The folder in the S3 bucket where task results are stored.
     */
    public val outputS3Directory: kotlin.String = requireNotNull(builder.outputS3Directory) { "A non-null value must be provided for outputS3Directory" }
    /**
     * The ARN of the task.
     */
    public val quantumTaskArn: kotlin.String = requireNotNull(builder.quantumTaskArn) { "A non-null value must be provided for quantumTaskArn" }
    /**
     * Queue information for the requested quantum task. Only returned if `QueueInfo` is specified in the `additionalAttributeNames"` field in the `GetQuantumTask` API request.
     */
    public val queueInfo: aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo? = builder.queueInfo
    /**
     * The number of shots used in the task.
     */
    public val shots: kotlin.Long = requireNotNull(builder.shots) { "A non-null value must be provided for shots" }
    /**
     * The status of the task.
     */
    public val status: aws.sdk.kotlin.services.braket.model.QuantumTaskStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags that belong to this task.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetQuantumTaskResponse(")
        append("associations=$associations,")
        append("createdAt=$createdAt,")
        append("deviceArn=$deviceArn,")
        append("deviceParameters=$deviceParameters,")
        append("endedAt=$endedAt,")
        append("failureReason=$failureReason,")
        append("jobArn=$jobArn,")
        append("outputS3Bucket=$outputS3Bucket,")
        append("outputS3Directory=$outputS3Directory,")
        append("quantumTaskArn=$quantumTaskArn,")
        append("queueInfo=$queueInfo,")
        append("shots=$shots,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associations?.hashCode() ?: 0
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (deviceArn.hashCode())
        result = 31 * result + (deviceParameters.hashCode())
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (outputS3Bucket.hashCode())
        result = 31 * result + (outputS3Directory.hashCode())
        result = 31 * result + (quantumTaskArn.hashCode())
        result = 31 * result + (queueInfo?.hashCode() ?: 0)
        result = 31 * result + (shots.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetQuantumTaskResponse

        if (associations != other.associations) return false
        if (createdAt != other.createdAt) return false
        if (deviceArn != other.deviceArn) return false
        if (deviceParameters != other.deviceParameters) return false
        if (endedAt != other.endedAt) return false
        if (failureReason != other.failureReason) return false
        if (jobArn != other.jobArn) return false
        if (outputS3Bucket != other.outputS3Bucket) return false
        if (outputS3Directory != other.outputS3Directory) return false
        if (quantumTaskArn != other.quantumTaskArn) return false
        if (queueInfo != other.queueInfo) return false
        if (shots != other.shots) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of Amazon Braket resources associated with the quantum task.
         */
        public var associations: List<Association>? = null
        /**
         * The time at which the task was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the device the task was run on.
         */
        public var deviceArn: kotlin.String? = null
        /**
         * The parameters for the device on which the task ran.
         */
        public var deviceParameters: kotlin.String? = null
        /**
         * The time at which the task ended.
         */
        public var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason that a task failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The ARN of the Amazon Braket job associated with the quantum task.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The S3 bucket where task results are stored.
         */
        public var outputS3Bucket: kotlin.String? = null
        /**
         * The folder in the S3 bucket where task results are stored.
         */
        public var outputS3Directory: kotlin.String? = null
        /**
         * The ARN of the task.
         */
        public var quantumTaskArn: kotlin.String? = null
        /**
         * Queue information for the requested quantum task. Only returned if `QueueInfo` is specified in the `additionalAttributeNames"` field in the `GetQuantumTask` API request.
         */
        public var queueInfo: aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo? = null
        /**
         * The number of shots used in the task.
         */
        public var shots: kotlin.Long? = null
        /**
         * The status of the task.
         */
        public var status: aws.sdk.kotlin.services.braket.model.QuantumTaskStatus? = null
        /**
         * The tags that belong to this task.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse) : this() {
            this.associations = x.associations
            this.createdAt = x.createdAt
            this.deviceArn = x.deviceArn
            this.deviceParameters = x.deviceParameters
            this.endedAt = x.endedAt
            this.failureReason = x.failureReason
            this.jobArn = x.jobArn
            this.outputS3Bucket = x.outputS3Bucket
            this.outputS3Directory = x.outputS3Directory
            this.quantumTaskArn = x.quantumTaskArn
            this.queueInfo = x.queueInfo
            this.shots = x.shots
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse = GetQuantumTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo] inside the given [block]
         */
        public fun queueInfo(block: aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo.Builder.() -> kotlin.Unit) {
            this.queueInfo = aws.sdk.kotlin.services.braket.model.QuantumTaskQueueInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (deviceArn == null) deviceArn = ""
            if (deviceParameters == null) deviceParameters = ""
            if (outputS3Bucket == null) outputS3Bucket = ""
            if (outputS3Directory == null) outputS3Directory = ""
            if (quantumTaskArn == null) quantumTaskArn = ""
            if (shots == null) shots = 0L
            if (status == null) status = QuantumTaskStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
