// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about tasks and jobs queued on a device.
 */
public class DeviceQueueInfo private constructor(builder: Builder) {
    /**
     * The name of the queue.
     */
    public val queue: aws.sdk.kotlin.services.braket.model.QueueName = requireNotNull(builder.queue) { "A non-null value must be provided for queue" }
    /**
     * Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks in a normal queue.
     */
    public val queuePriority: aws.sdk.kotlin.services.braket.model.QueuePriority? = builder.queuePriority
    /**
     * The number of jobs or tasks in the queue for a given device.
     */
    public val queueSize: kotlin.String = requireNotNull(builder.queueSize) { "A non-null value must be provided for queueSize" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.DeviceQueueInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceQueueInfo(")
        append("queue=$queue,")
        append("queuePriority=$queuePriority,")
        append("queueSize=$queueSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queue.hashCode()
        result = 31 * result + (queuePriority?.hashCode() ?: 0)
        result = 31 * result + (queueSize.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceQueueInfo

        if (queue != other.queue) return false
        if (queuePriority != other.queuePriority) return false
        if (queueSize != other.queueSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.DeviceQueueInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the queue.
         */
        public var queue: aws.sdk.kotlin.services.braket.model.QueueName? = null
        /**
         * Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks in a normal queue.
         */
        public var queuePriority: aws.sdk.kotlin.services.braket.model.QueuePriority? = null
        /**
         * The number of jobs or tasks in the queue for a given device.
         */
        public var queueSize: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.DeviceQueueInfo) : this() {
            this.queue = x.queue
            this.queuePriority = x.queuePriority
            this.queueSize = x.queueSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.DeviceQueueInfo = DeviceQueueInfo(this)

        internal fun correctErrors(): Builder {
            if (queue == null) queue = QueueName.SdkUnknown("no value provided")
            if (queueSize == null) queueSize = ""
            return this
        }
    }
}
