// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateQuantumTaskRequest private constructor(builder: Builder) {
    /**
     * The action associated with the task.
     */
    public val action: kotlin.String = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The list of Amazon Braket resources associated with the quantum task.
     */
    public val associations: List<Association>? = builder.associations
    /**
     * The client token associated with the request.
     */
    public val clientToken: kotlin.String = requireNotNull(builder.clientToken) { "A non-null value must be provided for clientToken" }
    /**
     * The ARN of the device to run the task on.
     */
    public val deviceArn: kotlin.String = requireNotNull(builder.deviceArn) { "A non-null value must be provided for deviceArn" }
    /**
     * The parameters for the device to run the task on.
     */
    public val deviceParameters: kotlin.String? = builder.deviceParameters
    /**
     * The token for an Amazon Braket job that associates it with the quantum task.
     */
    public val jobToken: kotlin.String? = builder.jobToken
    /**
     * The S3 bucket to store task result files in.
     */
    public val outputS3Bucket: kotlin.String = requireNotNull(builder.outputS3Bucket) { "A non-null value must be provided for outputS3Bucket" }
    /**
     * The key prefix for the location in the S3 bucket to store task results in.
     */
    public val outputS3KeyPrefix: kotlin.String = requireNotNull(builder.outputS3KeyPrefix) { "A non-null value must be provided for outputS3KeyPrefix" }
    /**
     * The number of shots to use for the task.
     */
    public val shots: kotlin.Long = requireNotNull(builder.shots) { "A non-null value must be provided for shots" }
    /**
     * Tags to be added to the quantum task you're creating.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.CreateQuantumTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQuantumTaskRequest(")
        append("action=$action,")
        append("associations=$associations,")
        append("clientToken=$clientToken,")
        append("deviceArn=$deviceArn,")
        append("deviceParameters=$deviceParameters,")
        append("jobToken=$jobToken,")
        append("outputS3Bucket=$outputS3Bucket,")
        append("outputS3KeyPrefix=$outputS3KeyPrefix,")
        append("shots=$shots,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (associations?.hashCode() ?: 0)
        result = 31 * result + (clientToken.hashCode())
        result = 31 * result + (deviceArn.hashCode())
        result = 31 * result + (deviceParameters?.hashCode() ?: 0)
        result = 31 * result + (jobToken?.hashCode() ?: 0)
        result = 31 * result + (outputS3Bucket.hashCode())
        result = 31 * result + (outputS3KeyPrefix.hashCode())
        result = 31 * result + (shots.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQuantumTaskRequest

        if (action != other.action) return false
        if (associations != other.associations) return false
        if (clientToken != other.clientToken) return false
        if (deviceArn != other.deviceArn) return false
        if (deviceParameters != other.deviceParameters) return false
        if (jobToken != other.jobToken) return false
        if (outputS3Bucket != other.outputS3Bucket) return false
        if (outputS3KeyPrefix != other.outputS3KeyPrefix) return false
        if (shots != other.shots) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.CreateQuantumTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action associated with the task.
         */
        public var action: kotlin.String? = null
        /**
         * The list of Amazon Braket resources associated with the quantum task.
         */
        public var associations: List<Association>? = null
        /**
         * The client token associated with the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ARN of the device to run the task on.
         */
        public var deviceArn: kotlin.String? = null
        /**
         * The parameters for the device to run the task on.
         */
        public var deviceParameters: kotlin.String? = null
        /**
         * The token for an Amazon Braket job that associates it with the quantum task.
         */
        public var jobToken: kotlin.String? = null
        /**
         * The S3 bucket to store task result files in.
         */
        public var outputS3Bucket: kotlin.String? = null
        /**
         * The key prefix for the location in the S3 bucket to store task results in.
         */
        public var outputS3KeyPrefix: kotlin.String? = null
        /**
         * The number of shots to use for the task.
         */
        public var shots: kotlin.Long? = null
        /**
         * Tags to be added to the quantum task you're creating.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.CreateQuantumTaskRequest) : this() {
            this.action = x.action
            this.associations = x.associations
            this.clientToken = x.clientToken
            this.deviceArn = x.deviceArn
            this.deviceParameters = x.deviceParameters
            this.jobToken = x.jobToken
            this.outputS3Bucket = x.outputS3Bucket
            this.outputS3KeyPrefix = x.outputS3KeyPrefix
            this.shots = x.shots
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.CreateQuantumTaskRequest = CreateQuantumTaskRequest(this)

        internal fun correctErrors(): Builder {
            if (action == null) action = ""
            if (clientToken == null) clientToken = ""
            if (deviceArn == null) deviceArn = ""
            if (outputS3Bucket == null) outputS3Bucket = ""
            if (outputS3KeyPrefix == null) outputS3KeyPrefix = ""
            if (shots == null) shots = 0L
            return this
        }
    }
}
