// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.braket.auth.BraketAuthSchemeProvider
import aws.sdk.kotlin.services.braket.auth.DefaultBraketAuthSchemeProvider
import aws.sdk.kotlin.services.braket.endpoints.BraketEndpointParameters
import aws.sdk.kotlin.services.braket.endpoints.BraketEndpointProvider
import aws.sdk.kotlin.services.braket.endpoints.DefaultBraketEndpointProvider
import aws.sdk.kotlin.services.braket.model.CancelJobRequest
import aws.sdk.kotlin.services.braket.model.CancelJobResponse
import aws.sdk.kotlin.services.braket.model.CancelQuantumTaskRequest
import aws.sdk.kotlin.services.braket.model.CancelQuantumTaskResponse
import aws.sdk.kotlin.services.braket.model.CreateJobRequest
import aws.sdk.kotlin.services.braket.model.CreateJobResponse
import aws.sdk.kotlin.services.braket.model.CreateQuantumTaskRequest
import aws.sdk.kotlin.services.braket.model.CreateQuantumTaskResponse
import aws.sdk.kotlin.services.braket.model.GetDeviceRequest
import aws.sdk.kotlin.services.braket.model.GetDeviceResponse
import aws.sdk.kotlin.services.braket.model.GetJobRequest
import aws.sdk.kotlin.services.braket.model.GetJobResponse
import aws.sdk.kotlin.services.braket.model.GetQuantumTaskRequest
import aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse
import aws.sdk.kotlin.services.braket.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.braket.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.braket.model.SearchDevicesRequest
import aws.sdk.kotlin.services.braket.model.SearchDevicesResponse
import aws.sdk.kotlin.services.braket.model.SearchJobsRequest
import aws.sdk.kotlin.services.braket.model.SearchJobsResponse
import aws.sdk.kotlin.services.braket.model.SearchQuantumTasksRequest
import aws.sdk.kotlin.services.braket.model.SearchQuantumTasksResponse
import aws.sdk.kotlin.services.braket.model.TagResourceRequest
import aws.sdk.kotlin.services.braket.model.TagResourceResponse
import aws.sdk.kotlin.services.braket.model.UntagResourceRequest
import aws.sdk.kotlin.services.braket.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Braket"
public const val SdkVersion: String = "1.2.52"
public const val ServiceApiVersion: String = "2019-09-01"

/**
 * The Amazon Braket API Reference provides information about the operations and structures supported in Amazon Braket.
 *
 * Additional Resources:
 * + [Amazon Braket Developer Guide](https://docs.aws.amazon.com/braket/latest/developerguide/what-is-braket.html)
 */
public interface BraketClient : SdkClient {
    /**
     * BraketClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BraketClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Braket",
                "BRAKET",
                "braket",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BraketClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BraketClient = DefaultBraketClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BraketEndpointProvider = builder.endpointProvider ?: DefaultBraketEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: BraketAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBraketAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Braket"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BraketEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BraketAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels an Amazon Braket job.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Cancels the specified task.
     */
    public suspend fun cancelQuantumTask(input: CancelQuantumTaskRequest): CancelQuantumTaskResponse

    /**
     * Creates an Amazon Braket job.
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * Creates a quantum task.
     */
    public suspend fun createQuantumTask(input: CreateQuantumTaskRequest): CreateQuantumTaskResponse

    /**
     * Retrieves the devices available in Amazon Braket.
     *
     * For backwards compatibility with older versions of BraketSchemas, OpenQASM information is omitted from GetDevice API calls. To get this information the user-agent needs to present a recent version of the BraketSchemas (1.8.0 or later). The Braket SDK automatically reports this for you. If you do not see OpenQASM results in the GetDevice response when using a Braket SDK, you may need to set AWS_EXECUTION_ENV environment variable to configure user-agent. See the code examples provided below for how to do this for the AWS CLI, Boto3, and the Go, Java, and JavaScript/TypeScript SDKs.
     */
    public suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse

    /**
     * Retrieves the specified Amazon Braket job.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Retrieves the specified quantum task.
     */
    public suspend fun getQuantumTask(input: GetQuantumTaskRequest): GetQuantumTaskResponse

    /**
     * Shows the tags associated with this resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Searches for devices using the specified filters.
     */
    public suspend fun searchDevices(input: SearchDevicesRequest): SearchDevicesResponse

    /**
     * Searches for Amazon Braket jobs that match the specified filter values.
     */
    public suspend fun searchJobs(input: SearchJobsRequest): SearchJobsResponse

    /**
     * Searches for tasks that match the specified filter values.
     */
    public suspend fun searchQuantumTasks(input: SearchQuantumTasksRequest): SearchQuantumTasksResponse

    /**
     * Add a tag to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BraketClient.withConfig(block: BraketClient.Config.Builder.() -> Unit): BraketClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBraketClient(newConfig)
}

/**
 * Cancels an Amazon Braket job.
 */
public suspend inline fun BraketClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified task.
 */
public suspend inline fun BraketClient.cancelQuantumTask(crossinline block: CancelQuantumTaskRequest.Builder.() -> Unit): CancelQuantumTaskResponse = cancelQuantumTask(CancelQuantumTaskRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Braket job.
 */
public suspend inline fun BraketClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * Creates a quantum task.
 */
public suspend inline fun BraketClient.createQuantumTask(crossinline block: CreateQuantumTaskRequest.Builder.() -> Unit): CreateQuantumTaskResponse = createQuantumTask(CreateQuantumTaskRequest.Builder().apply(block).build())

/**
 * Retrieves the devices available in Amazon Braket.
 *
 * For backwards compatibility with older versions of BraketSchemas, OpenQASM information is omitted from GetDevice API calls. To get this information the user-agent needs to present a recent version of the BraketSchemas (1.8.0 or later). The Braket SDK automatically reports this for you. If you do not see OpenQASM results in the GetDevice response when using a Braket SDK, you may need to set AWS_EXECUTION_ENV environment variable to configure user-agent. See the code examples provided below for how to do this for the AWS CLI, Boto3, and the Go, Java, and JavaScript/TypeScript SDKs.
 */
public suspend inline fun BraketClient.getDevice(crossinline block: GetDeviceRequest.Builder.() -> Unit): GetDeviceResponse = getDevice(GetDeviceRequest.Builder().apply(block).build())

/**
 * Retrieves the specified Amazon Braket job.
 */
public suspend inline fun BraketClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * Retrieves the specified quantum task.
 */
public suspend inline fun BraketClient.getQuantumTask(crossinline block: GetQuantumTaskRequest.Builder.() -> Unit): GetQuantumTaskResponse = getQuantumTask(GetQuantumTaskRequest.Builder().apply(block).build())

/**
 * Shows the tags associated with this resource.
 */
public suspend inline fun BraketClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Searches for devices using the specified filters.
 */
public suspend inline fun BraketClient.searchDevices(crossinline block: SearchDevicesRequest.Builder.() -> Unit): SearchDevicesResponse = searchDevices(SearchDevicesRequest.Builder().apply(block).build())

/**
 * Searches for Amazon Braket jobs that match the specified filter values.
 */
public suspend inline fun BraketClient.searchJobs(crossinline block: SearchJobsRequest.Builder.() -> Unit): SearchJobsResponse = searchJobs(SearchJobsRequest.Builder().apply(block).build())

/**
 * Searches for tasks that match the specified filter values.
 */
public suspend inline fun BraketClient.searchQuantumTasks(crossinline block: SearchQuantumTasksRequest.Builder.() -> Unit): SearchQuantumTasksResponse = searchQuantumTasks(SearchQuantumTasksRequest.Builder().apply(block).build())

/**
 * Add a tag to the specified resource.
 */
public suspend inline fun BraketClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove tags from a resource.
 */
public suspend inline fun BraketClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
