// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.braket.model.BraketException
import aws.sdk.kotlin.services.braket.model.GetQuantumTaskResponse
import aws.sdk.kotlin.services.braket.model.QuantumTaskStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetQuantumTaskOperationDeserializer: HttpDeserialize<GetQuantumTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetQuantumTaskResponse {
        if (!response.status.isSuccess()) {
            throwGetQuantumTaskError(context, response)
        }
        val builder = GetQuantumTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetQuantumTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetQuantumTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BraketException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BraketException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQuantumTaskOperationBody(builder: GetQuantumTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceArn"))
    val DEVICEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceParameters"))
    val ENDEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endedAt"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val OUTPUTS3BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputS3Bucket"))
    val OUTPUTS3DIRECTORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputS3Directory"))
    val QUANTUMTASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("quantumTaskArn"))
    val SHOTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("shots"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DEVICEARN_DESCRIPTOR)
        field(DEVICEPARAMETERS_DESCRIPTOR)
        field(ENDEDAT_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(OUTPUTS3BUCKET_DESCRIPTOR)
        field(OUTPUTS3DIRECTORY_DESCRIPTOR)
        field(QUANTUMTASKARN_DESCRIPTOR)
        field(SHOTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                DEVICEARN_DESCRIPTOR.index -> builder.deviceArn = deserializeString()
                DEVICEPARAMETERS_DESCRIPTOR.index -> builder.deviceParameters = deserializeString()
                ENDEDAT_DESCRIPTOR.index -> builder.endedAt = deserializeString().let { Instant.fromIso8601(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                OUTPUTS3BUCKET_DESCRIPTOR.index -> builder.outputS3Bucket = deserializeString()
                OUTPUTS3DIRECTORY_DESCRIPTOR.index -> builder.outputS3Directory = deserializeString()
                QUANTUMTASKARN_DESCRIPTOR.index -> builder.quantumTaskArn = deserializeString()
                SHOTS_DESCRIPTOR.index -> builder.shots = deserializeLong()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { QuantumTaskStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
