// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.braket.model.BraketException
import aws.sdk.kotlin.services.braket.model.DeviceStatus
import aws.sdk.kotlin.services.braket.model.DeviceType
import aws.sdk.kotlin.services.braket.model.GetDeviceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDeviceOperationDeserializer: HttpDeserialize<GetDeviceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeviceResponse {
        if (!response.status.isSuccess()) {
            throwGetDeviceError(context, response)
        }
        val builder = GetDeviceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeviceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDeviceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BraketException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BraketException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeviceOperationBody(builder: GetDeviceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceArn"))
    val DEVICECAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceCapabilities"))
    val DEVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceName"))
    val DEVICESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceStatus"))
    val DEVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceType"))
    val PROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("providerName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICEARN_DESCRIPTOR)
        field(DEVICECAPABILITIES_DESCRIPTOR)
        field(DEVICENAME_DESCRIPTOR)
        field(DEVICESTATUS_DESCRIPTOR)
        field(DEVICETYPE_DESCRIPTOR)
        field(PROVIDERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICEARN_DESCRIPTOR.index -> builder.deviceArn = deserializeString()
                DEVICECAPABILITIES_DESCRIPTOR.index -> builder.deviceCapabilities = deserializeString()
                DEVICENAME_DESCRIPTOR.index -> builder.deviceName = deserializeString()
                DEVICESTATUS_DESCRIPTOR.index -> builder.deviceStatus = deserializeString().let { DeviceStatus.fromValue(it) }
                DEVICETYPE_DESCRIPTOR.index -> builder.deviceType = deserializeString().let { DeviceType.fromValue(it) }
                PROVIDERNAME_DESCRIPTOR.index -> builder.providerName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
