// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.braket.model.BraketException
import aws.sdk.kotlin.services.braket.model.CreateQuantumTaskResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateQuantumTaskOperationDeserializer: HttpDeserialize<CreateQuantumTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateQuantumTaskResponse {
        if (!response.status.isSuccess()) {
            throwCreateQuantumTaskError(context, response)
        }
        val builder = CreateQuantumTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateQuantumTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateQuantumTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BraketException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeviceOfflineException" -> DeviceOfflineExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeviceRetiredException" -> DeviceRetiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BraketException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateQuantumTaskOperationBody(builder: CreateQuantumTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val QUANTUMTASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("quantumTaskArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUANTUMTASKARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                QUANTUMTASKARN_DESCRIPTOR.index -> builder.quantumTaskArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
