// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Includes information about a quantum task.
 */
class QuantumTaskSummary private constructor(builder: Builder) {
    /**
     * The time at which the task was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ARN of the device the task ran on.
     */
    val deviceArn: kotlin.String? = builder.deviceArn
    /**
     * The time at which the task finished.
     */
    val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * The S3 bucket where the task result file is stored..
     */
    val outputS3Bucket: kotlin.String? = builder.outputS3Bucket
    /**
     * The folder in the S3 bucket where the task result file is stored.
     */
    val outputS3Directory: kotlin.String? = builder.outputS3Directory
    /**
     * The ARN of the task.
     */
    val quantumTaskArn: kotlin.String? = builder.quantumTaskArn
    /**
     * The shots used for the task.
     */
    val shots: kotlin.Long? = builder.shots
    /**
     * The status of the task.
     */
    val status: aws.sdk.kotlin.services.braket.model.QuantumTaskStatus? = builder.status
    /**
     * Displays the key, value pairs of tags associated with this quantum task.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.QuantumTaskSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuantumTaskSummary(")
        append("createdAt=$createdAt,")
        append("deviceArn=$deviceArn,")
        append("endedAt=$endedAt,")
        append("outputS3Bucket=$outputS3Bucket,")
        append("outputS3Directory=$outputS3Directory,")
        append("quantumTaskArn=$quantumTaskArn,")
        append("shots=$shots,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (deviceArn?.hashCode() ?: 0)
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (outputS3Bucket?.hashCode() ?: 0)
        result = 31 * result + (outputS3Directory?.hashCode() ?: 0)
        result = 31 * result + (quantumTaskArn?.hashCode() ?: 0)
        result = 31 * result + (shots?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuantumTaskSummary

        if (createdAt != other.createdAt) return false
        if (deviceArn != other.deviceArn) return false
        if (endedAt != other.endedAt) return false
        if (outputS3Bucket != other.outputS3Bucket) return false
        if (outputS3Directory != other.outputS3Directory) return false
        if (quantumTaskArn != other.quantumTaskArn) return false
        if (shots != other.shots) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.QuantumTaskSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time at which the task was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the device the task ran on.
         */
        var deviceArn: kotlin.String? = null
        /**
         * The time at which the task finished.
         */
        var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The S3 bucket where the task result file is stored..
         */
        var outputS3Bucket: kotlin.String? = null
        /**
         * The folder in the S3 bucket where the task result file is stored.
         */
        var outputS3Directory: kotlin.String? = null
        /**
         * The ARN of the task.
         */
        var quantumTaskArn: kotlin.String? = null
        /**
         * The shots used for the task.
         */
        var shots: kotlin.Long? = null
        /**
         * The status of the task.
         */
        var status: aws.sdk.kotlin.services.braket.model.QuantumTaskStatus? = null
        /**
         * Displays the key, value pairs of tags associated with this quantum task.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.QuantumTaskSummary) : this() {
            this.createdAt = x.createdAt
            this.deviceArn = x.deviceArn
            this.endedAt = x.endedAt
            this.outputS3Bucket = x.outputS3Bucket
            this.outputS3Directory = x.outputS3Directory
            this.quantumTaskArn = x.quantumTaskArn
            this.shots = x.shots
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.QuantumTaskSummary = QuantumTaskSummary(this)
    }
}
