// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about an Amazon Braket job.
 */
class JobSummary private constructor(builder: Builder) {
    /**
     * The date and time that the Amazon Braket job was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Provides summary information about the primary device used by an Amazon Braket job.
     */
    val device: kotlin.String? = builder.device
    /**
     * The date and time that the Amazon Braket job ended.
     */
    val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * The ARN of the Amazon Braket job.
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The name of the Amazon Braket job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The date and time that the Amazon Braket job was started.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the Amazon Braket job.
     */
    val status: aws.sdk.kotlin.services.braket.model.JobPrimaryStatus? = builder.status
    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("createdAt=$createdAt,")
        append("device=$device,")
        append("endedAt=$endedAt,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (device?.hashCode() ?: 0)
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (createdAt != other.createdAt) return false
        if (device != other.device) return false
        if (endedAt != other.endedAt) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.JobSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the Amazon Braket job was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides summary information about the primary device used by an Amazon Braket job.
         */
        var device: kotlin.String? = null
        /**
         * The date and time that the Amazon Braket job ended.
         */
        var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the Amazon Braket job.
         */
        var jobArn: kotlin.String? = null
        /**
         * The name of the Amazon Braket job.
         */
        var jobName: kotlin.String? = null
        /**
         * The date and time that the Amazon Braket job was started.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the Amazon Braket job.
         */
        var status: aws.sdk.kotlin.services.braket.model.JobPrimaryStatus? = null
        /**
         * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.JobSummary) : this() {
            this.createdAt = x.createdAt
            this.device = x.device
            this.endedAt = x.endedAt
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.startedAt = x.startedAt
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.JobSummary = JobSummary(this)
    }
}
