// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model



/**
 * Configures the resource instances to use while running the Amazon Braket hybrid job on Amazon Braket.
 */
class InstanceConfig private constructor(builder: Builder) {
    /**
     * Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket. The default value is 1.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Configures the type resource instances to use while running an Amazon Braket hybrid job.
     */
    val instanceType: aws.sdk.kotlin.services.braket.model.InstanceType? = builder.instanceType
    /**
     * The size of the storage volume, in GB, that user wants to provision.
     */
    val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.InstanceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceConfig(")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("volumeSizeInGb=$volumeSizeInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceCount ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceConfig

        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.InstanceConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configures the number of resource instances to use while running an Amazon Braket job on Amazon Braket. The default value is 1.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * Configures the type resource instances to use while running an Amazon Braket hybrid job.
         */
        var instanceType: aws.sdk.kotlin.services.braket.model.InstanceType? = null
        /**
         * The size of the storage volume, in GB, that user wants to provision.
         */
        var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.InstanceConfig) : this() {
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.InstanceConfig = InstanceConfig(this)
    }
}
