// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model

import aws.smithy.kotlin.runtime.time.Instant

class GetJobResponse private constructor(builder: Builder) {
    /**
     * Definition of the Amazon Braket job created. Specifies the container image the job uses, information about the Python scripts used for entry and training, and the user-defined metrics used to evaluation the job.
     */
    val algorithmSpecification: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification? = builder.algorithmSpecification
    /**
     * The billable time the Amazon Braket job used to complete.
     */
    val billableDuration: kotlin.Int? = builder.billableDuration
    /**
     * Information about the output locations for job checkpoint data.
     */
    val checkpointConfig: aws.sdk.kotlin.services.braket.model.JobCheckpointConfig? = builder.checkpointConfig
    /**
     * The date and time that the Amazon Braket job was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
     */
    val deviceConfig: aws.sdk.kotlin.services.braket.model.DeviceConfig? = builder.deviceConfig
    /**
     * The date and time that the Amazon Braket job ended.
     */
    val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * Details about the type and time events occurred related to the Amazon Braket job.
     */
    val events: List<JobEventDetails>? = builder.events
    /**
     * A description of the reason why an Amazon Braket job failed, if it failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.
     */
    val hyperParameters: Map<String, String>? = builder.hyperParameters
    /**
     * A list of parameters that specify the name and type of input data and where it is located.
     */
    val inputDataConfig: List<InputFileConfig>? = builder.inputDataConfig
    /**
     * The resource instances to use while running the hybrid job on Amazon Braket.
     */
    val instanceConfig: aws.sdk.kotlin.services.braket.model.InstanceConfig? = builder.instanceConfig
    /**
     * The ARN of the Amazon Braket job.
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The name of the Amazon Braket job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The path to the S3 location where job artifacts are stored and the encryption key used to store them there.
     */
    val outputDataConfig: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the s3 buckets of a user.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The date and time that the Amazon Braket job was started.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the Amazon Braket job.
     */
    val status: aws.sdk.kotlin.services.braket.model.JobPrimaryStatus? = builder.status
    /**
     * The user-defined criteria that specifies when to stop a job running.
     */
    val stoppingCondition: aws.sdk.kotlin.services.braket.model.JobStoppingCondition? = builder.stoppingCondition
    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.GetJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetJobResponse(")
        append("algorithmSpecification=$algorithmSpecification,")
        append("billableDuration=$billableDuration,")
        append("checkpointConfig=$checkpointConfig,")
        append("createdAt=$createdAt,")
        append("deviceConfig=$deviceConfig,")
        append("endedAt=$endedAt,")
        append("events=$events,")
        append("failureReason=$failureReason,")
        append("hyperParameters=$hyperParameters,")
        append("inputDataConfig=$inputDataConfig,")
        append("instanceConfig=$instanceConfig,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmSpecification?.hashCode() ?: 0
        result = 31 * result + (billableDuration ?: 0)
        result = 31 * result + (checkpointConfig?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deviceConfig?.hashCode() ?: 0)
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (hyperParameters?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (instanceConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetJobResponse

        if (algorithmSpecification != other.algorithmSpecification) return false
        if (billableDuration != other.billableDuration) return false
        if (checkpointConfig != other.checkpointConfig) return false
        if (createdAt != other.createdAt) return false
        if (deviceConfig != other.deviceConfig) return false
        if (endedAt != other.endedAt) return false
        if (events != other.events) return false
        if (failureReason != other.failureReason) return false
        if (hyperParameters != other.hyperParameters) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (instanceConfig != other.instanceConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.GetJobResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Definition of the Amazon Braket job created. Specifies the container image the job uses, information about the Python scripts used for entry and training, and the user-defined metrics used to evaluation the job.
         */
        var algorithmSpecification: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification? = null
        /**
         * The billable time the Amazon Braket job used to complete.
         */
        var billableDuration: kotlin.Int? = null
        /**
         * Information about the output locations for job checkpoint data.
         */
        var checkpointConfig: aws.sdk.kotlin.services.braket.model.JobCheckpointConfig? = null
        /**
         * The date and time that the Amazon Braket job was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The quantum processing unit (QPU) or simulator used to run the Amazon Braket job.
         */
        var deviceConfig: aws.sdk.kotlin.services.braket.model.DeviceConfig? = null
        /**
         * The date and time that the Amazon Braket job ended.
         */
        var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details about the type and time events occurred related to the Amazon Braket job.
         */
        var events: List<JobEventDetails>? = null
        /**
         * A description of the reason why an Amazon Braket job failed, if it failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the traiing job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.
         */
        var hyperParameters: Map<String, String>? = null
        /**
         * A list of parameters that specify the name and type of input data and where it is located.
         */
        var inputDataConfig: List<InputFileConfig>? = null
        /**
         * The resource instances to use while running the hybrid job on Amazon Braket.
         */
        var instanceConfig: aws.sdk.kotlin.services.braket.model.InstanceConfig? = null
        /**
         * The ARN of the Amazon Braket job.
         */
        var jobArn: kotlin.String? = null
        /**
         * The name of the Amazon Braket job.
         */
        var jobName: kotlin.String? = null
        /**
         * The path to the S3 location where job artifacts are stored and the encryption key used to store them there.
         */
        var outputDataConfig: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the s3 buckets of a user.
         */
        var roleArn: kotlin.String? = null
        /**
         * The date and time that the Amazon Braket job was started.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the Amazon Braket job.
         */
        var status: aws.sdk.kotlin.services.braket.model.JobPrimaryStatus? = null
        /**
         * The user-defined criteria that specifies when to stop a job running.
         */
        var stoppingCondition: aws.sdk.kotlin.services.braket.model.JobStoppingCondition? = null
        /**
         * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.GetJobResponse) : this() {
            this.algorithmSpecification = x.algorithmSpecification
            this.billableDuration = x.billableDuration
            this.checkpointConfig = x.checkpointConfig
            this.createdAt = x.createdAt
            this.deviceConfig = x.deviceConfig
            this.endedAt = x.endedAt
            this.events = x.events
            this.failureReason = x.failureReason
            this.hyperParameters = x.hyperParameters
            this.inputDataConfig = x.inputDataConfig
            this.instanceConfig = x.instanceConfig
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
            this.startedAt = x.startedAt
            this.status = x.status
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.GetJobResponse = GetJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.AlgorithmSpecification] inside the given [block]
         */
        fun algorithmSpecification(block: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.algorithmSpecification = aws.sdk.kotlin.services.braket.model.AlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.JobCheckpointConfig] inside the given [block]
         */
        fun checkpointConfig(block: aws.sdk.kotlin.services.braket.model.JobCheckpointConfig.Builder.() -> kotlin.Unit) {
            this.checkpointConfig = aws.sdk.kotlin.services.braket.model.JobCheckpointConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.DeviceConfig] inside the given [block]
         */
        fun deviceConfig(block: aws.sdk.kotlin.services.braket.model.DeviceConfig.Builder.() -> kotlin.Unit) {
            this.deviceConfig = aws.sdk.kotlin.services.braket.model.DeviceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.InstanceConfig] inside the given [block]
         */
        fun instanceConfig(block: aws.sdk.kotlin.services.braket.model.InstanceConfig.Builder.() -> kotlin.Unit) {
            this.instanceConfig = aws.sdk.kotlin.services.braket.model.InstanceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.JobOutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.braket.model.JobOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.JobStoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.braket.model.JobStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.braket.model.JobStoppingCondition.invoke(block)
        }
    }
}
