// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model



class CreateJobRequest private constructor(builder: Builder) {
    /**
     * Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information about the Python scripts used for entry and training.
     */
    val algorithmSpecification: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification? = builder.algorithmSpecification
    /**
     * Information about the output locations for job checkpoint data.
     */
    val checkpointConfig: aws.sdk.kotlin.services.braket.model.JobCheckpointConfig? = builder.checkpointConfig
    /**
     * A unique token that guarantees that the call to this API is idempotent.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
     */
    val deviceConfig: aws.sdk.kotlin.services.braket.model.DeviceConfig? = builder.deviceConfig
    /**
     * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.
     */
    val hyperParameters: Map<String, String>? = builder.hyperParameters
    /**
     * A list of parameters that specify the name and type of input data and where it is located.
     */
    val inputDataConfig: List<InputFileConfig>? = builder.inputDataConfig
    /**
     * Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
     */
    val instanceConfig: aws.sdk.kotlin.services.braket.model.InstanceConfig? = builder.instanceConfig
    /**
     * The name of the Amazon Braket job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The path to the S3 location where you want to store job artifacts and the encryption key used to store them.
     */
    val outputDataConfig: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the users' s3 buckets.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The user-defined criteria that specifies when a job stops running.
     */
    val stoppingCondition: aws.sdk.kotlin.services.braket.model.JobStoppingCondition? = builder.stoppingCondition
    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("algorithmSpecification=$algorithmSpecification,")
        append("checkpointConfig=$checkpointConfig,")
        append("clientToken=$clientToken,")
        append("deviceConfig=$deviceConfig,")
        append("hyperParameters=$hyperParameters,")
        append("inputDataConfig=$inputDataConfig,")
        append("instanceConfig=$instanceConfig,")
        append("jobName=$jobName,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmSpecification?.hashCode() ?: 0
        result = 31 * result + (checkpointConfig?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (deviceConfig?.hashCode() ?: 0)
        result = 31 * result + (hyperParameters?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (instanceConfig?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (algorithmSpecification != other.algorithmSpecification) return false
        if (checkpointConfig != other.checkpointConfig) return false
        if (clientToken != other.clientToken) return false
        if (deviceConfig != other.deviceConfig) return false
        if (hyperParameters != other.hyperParameters) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (instanceConfig != other.instanceConfig) return false
        if (jobName != other.jobName) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.CreateJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information about the Python scripts used for entry and training.
         */
        var algorithmSpecification: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification? = null
        /**
         * Information about the output locations for job checkpoint data.
         */
        var checkpointConfig: aws.sdk.kotlin.services.braket.model.JobCheckpointConfig? = null
        /**
         * A unique token that guarantees that the call to this API is idempotent.
         */
        var clientToken: kotlin.String? = null
        /**
         * The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
         */
        var deviceConfig: aws.sdk.kotlin.services.braket.model.DeviceConfig? = null
        /**
         * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job. The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the value is the value of th hyperparameter.
         */
        var hyperParameters: Map<String, String>? = null
        /**
         * A list of parameters that specify the name and type of input data and where it is located.
         */
        var inputDataConfig: List<InputFileConfig>? = null
        /**
         * Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
         */
        var instanceConfig: aws.sdk.kotlin.services.braket.model.InstanceConfig? = null
        /**
         * The name of the Amazon Braket job.
         */
        var jobName: kotlin.String? = null
        /**
         * The path to the S3 location where you want to store job artifacts and the encryption key used to store them.
         */
        var outputDataConfig: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the users' s3 buckets.
         */
        var roleArn: kotlin.String? = null
        /**
         * The user-defined criteria that specifies when a job stops running.
         */
        var stoppingCondition: aws.sdk.kotlin.services.braket.model.JobStoppingCondition? = null
        /**
         * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.CreateJobRequest) : this() {
            this.algorithmSpecification = x.algorithmSpecification
            this.checkpointConfig = x.checkpointConfig
            this.clientToken = x.clientToken
            this.deviceConfig = x.deviceConfig
            this.hyperParameters = x.hyperParameters
            this.inputDataConfig = x.inputDataConfig
            this.instanceConfig = x.instanceConfig
            this.jobName = x.jobName
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.AlgorithmSpecification] inside the given [block]
         */
        fun algorithmSpecification(block: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.algorithmSpecification = aws.sdk.kotlin.services.braket.model.AlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.JobCheckpointConfig] inside the given [block]
         */
        fun checkpointConfig(block: aws.sdk.kotlin.services.braket.model.JobCheckpointConfig.Builder.() -> kotlin.Unit) {
            this.checkpointConfig = aws.sdk.kotlin.services.braket.model.JobCheckpointConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.DeviceConfig] inside the given [block]
         */
        fun deviceConfig(block: aws.sdk.kotlin.services.braket.model.DeviceConfig.Builder.() -> kotlin.Unit) {
            this.deviceConfig = aws.sdk.kotlin.services.braket.model.DeviceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.InstanceConfig] inside the given [block]
         */
        fun instanceConfig(block: aws.sdk.kotlin.services.braket.model.InstanceConfig.Builder.() -> kotlin.Unit) {
            this.instanceConfig = aws.sdk.kotlin.services.braket.model.InstanceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.JobOutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.braket.model.JobOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.braket.model.JobOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.JobStoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.braket.model.JobStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.braket.model.JobStoppingCondition.invoke(block)
        }
    }
}
