// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket.model



/**
 * Defines the Amazon Braket job to be created. Specifies the container image the job uses and the paths to the Python scripts used for entry and training.
 */
class AlgorithmSpecification private constructor(builder: Builder) {
    /**
     * The container image used to create an Amazon Braket job.
     */
    val containerImage: aws.sdk.kotlin.services.braket.model.ContainerImage? = builder.containerImage
    /**
     * Configures the paths to the Python scripts used for entry and training.
     */
    val scriptModeConfig: aws.sdk.kotlin.services.braket.model.ScriptModeConfig? = builder.scriptModeConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.braket.model.AlgorithmSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlgorithmSpecification(")
        append("containerImage=$containerImage,")
        append("scriptModeConfig=$scriptModeConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerImage?.hashCode() ?: 0
        result = 31 * result + (scriptModeConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlgorithmSpecification

        if (containerImage != other.containerImage) return false
        if (scriptModeConfig != other.scriptModeConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.braket.model.AlgorithmSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The container image used to create an Amazon Braket job.
         */
        var containerImage: aws.sdk.kotlin.services.braket.model.ContainerImage? = null
        /**
         * Configures the paths to the Python scripts used for entry and training.
         */
        var scriptModeConfig: aws.sdk.kotlin.services.braket.model.ScriptModeConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.braket.model.AlgorithmSpecification) : this() {
            this.containerImage = x.containerImage
            this.scriptModeConfig = x.scriptModeConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.braket.model.AlgorithmSpecification = AlgorithmSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.ContainerImage] inside the given [block]
         */
        fun containerImage(block: aws.sdk.kotlin.services.braket.model.ContainerImage.Builder.() -> kotlin.Unit) {
            this.containerImage = aws.sdk.kotlin.services.braket.model.ContainerImage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.braket.model.ScriptModeConfig] inside the given [block]
         */
        fun scriptModeConfig(block: aws.sdk.kotlin.services.braket.model.ScriptModeConfig.Builder.() -> kotlin.Unit) {
            this.scriptModeConfig = aws.sdk.kotlin.services.braket.model.ScriptModeConfig.invoke(block)
        }
    }
}
