// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.braket

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.braket.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.braket.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amazon Braket API Reference provides information about the operations and structures supported in Amazon Braket.
 *
 * Additional Resources:
 * + [Amazon Braket Developer Guide](https://docs.aws.amazon.com/braket/latest/developerguide/what-is-braket.html)
 */
interface BraketClient : SdkClient {

    override val serviceName: String
        get() = "Braket"
    /**
     * BraketClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): BraketClient {
            val config = Config.Builder().apply(block).build()
            return DefaultBraketClient(config)
        }

        operator fun invoke(config: Config): BraketClient = DefaultBraketClient(config)

        /**
         * Construct a [BraketClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): BraketClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultBraketClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels an Amazon Braket job.
     */
    suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Cancels the specified task.
     */
    suspend fun cancelQuantumTask(input: CancelQuantumTaskRequest): CancelQuantumTaskResponse

    /**
     * Creates an Amazon Braket job.
     */
    suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * Creates a quantum task.
     */
    suspend fun createQuantumTask(input: CreateQuantumTaskRequest): CreateQuantumTaskResponse

    /**
     * Retrieves the devices available in Amazon Braket.
     *
     * For backwards compatibility with older versions of BraketSchemas, OpenQASM information is omitted from GetDevice API calls. To get this information the user-agent needs to present a recent version of the BraketSchemas (1.8.0 or later). The Braket SDK automatically reports this for you. If you do not see OpenQASM results in the GetDevice response when using a Braket SDK, you may need to set AWS_EXECUTION_ENV environment variable to configure user-agent. See the code examples provided below for how to do this for the AWS CLI, Boto3, and the Go, Java, and JavaScript/TypeScript SDKs.
     */
    suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse

    /**
     * Retrieves the specified Amazon Braket job.
     */
    suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Retrieves the specified quantum task.
     */
    suspend fun getQuantumTask(input: GetQuantumTaskRequest): GetQuantumTaskResponse

    /**
     * Shows the tags associated with this resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Searches for devices using the specified filters.
     */
    suspend fun searchDevices(input: SearchDevicesRequest): SearchDevicesResponse

    /**
     * Searches for Amazon Braket jobs that match the specified filter values.
     */
    suspend fun searchJobs(input: SearchJobsRequest): SearchJobsResponse

    /**
     * Searches for tasks that match the specified filter values.
     */
    suspend fun searchQuantumTasks(input: SearchQuantumTasksRequest): SearchQuantumTasksResponse

    /**
     * Add a tag to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Cancels an Amazon Braket job.
 */
suspend inline fun BraketClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit) = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified task.
 */
suspend inline fun BraketClient.cancelQuantumTask(crossinline block: CancelQuantumTaskRequest.Builder.() -> Unit) = cancelQuantumTask(CancelQuantumTaskRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Braket job.
 */
suspend inline fun BraketClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit) = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * Creates a quantum task.
 */
suspend inline fun BraketClient.createQuantumTask(crossinline block: CreateQuantumTaskRequest.Builder.() -> Unit) = createQuantumTask(CreateQuantumTaskRequest.Builder().apply(block).build())

/**
 * Retrieves the devices available in Amazon Braket.
 *
 * For backwards compatibility with older versions of BraketSchemas, OpenQASM information is omitted from GetDevice API calls. To get this information the user-agent needs to present a recent version of the BraketSchemas (1.8.0 or later). The Braket SDK automatically reports this for you. If you do not see OpenQASM results in the GetDevice response when using a Braket SDK, you may need to set AWS_EXECUTION_ENV environment variable to configure user-agent. See the code examples provided below for how to do this for the AWS CLI, Boto3, and the Go, Java, and JavaScript/TypeScript SDKs.
 */
suspend inline fun BraketClient.getDevice(crossinline block: GetDeviceRequest.Builder.() -> Unit) = getDevice(GetDeviceRequest.Builder().apply(block).build())

/**
 * Retrieves the specified Amazon Braket job.
 */
suspend inline fun BraketClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit) = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * Retrieves the specified quantum task.
 */
suspend inline fun BraketClient.getQuantumTask(crossinline block: GetQuantumTaskRequest.Builder.() -> Unit) = getQuantumTask(GetQuantumTaskRequest.Builder().apply(block).build())

/**
 * Shows the tags associated with this resource.
 */
suspend inline fun BraketClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Searches for devices using the specified filters.
 */
suspend inline fun BraketClient.searchDevices(crossinline block: SearchDevicesRequest.Builder.() -> Unit) = searchDevices(SearchDevicesRequest.Builder().apply(block).build())

/**
 * Searches for Amazon Braket jobs that match the specified filter values.
 */
suspend inline fun BraketClient.searchJobs(crossinline block: SearchJobsRequest.Builder.() -> Unit) = searchJobs(SearchJobsRequest.Builder().apply(block).build())

/**
 * Searches for tasks that match the specified filter values.
 */
suspend inline fun BraketClient.searchQuantumTasks(crossinline block: SearchQuantumTasksRequest.Builder.() -> Unit) = searchQuantumTasks(SearchQuantumTasksRequest.Builder().apply(block).build())

/**
 * Add a tag to the specified resource.
 */
suspend inline fun BraketClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove tags from a resource.
 */
suspend inline fun BraketClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())
