// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.serde

import aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange
import aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomLineItemOperationSerializer: HttpSerializer.NonStreaming<CreateCustomLineItemRequest> {
    override fun serialize(context: ExecutionContext, input: CreateCustomLineItemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/create-custom-line-item"
        }

        builder.headers {
            append("X-Amzn-Client-Token", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
        }

        val payload = serializeCreateCustomLineItemOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateCustomLineItemOperationBody(context: ExecutionContext, input: CreateCustomLineItemRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountId"))
    val BILLINGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BillingGroupArn"))
    val BILLINGPERIODRANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BillingPeriodRange"))
    val CHARGEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ChargeDetails"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTID_DESCRIPTOR)
        field(BILLINGGROUPARN_DESCRIPTOR)
        field(BILLINGPERIODRANGE_DESCRIPTOR)
        field(CHARGEDETAILS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accountId?.let { field(ACCOUNTID_DESCRIPTOR, it) }
        field(BILLINGGROUPARN_DESCRIPTOR, input.billingGroupArn)
        input.billingPeriodRange?.let { field(BILLINGPERIODRANGE_DESCRIPTOR, it, ::serializeCustomLineItemBillingPeriodRangeDocument) }
        input.chargeDetails?.let { field(CHARGEDETAILS_DESCRIPTOR, it, ::serializeCustomLineItemChargeDetailsDocument) }
        field(DESCRIPTION_DESCRIPTOR, input.description)
        field(NAME_DESCRIPTOR, input.name)
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
