// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.paginators

import aws.sdk.kotlin.services.billingconductor.BillingconductorClient
import aws.sdk.kotlin.services.billingconductor.model.AccountAssociationsListElement
import aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportElement
import aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportResultElement
import aws.sdk.kotlin.services.billingconductor.model.BillingGroupListElement
import aws.sdk.kotlin.services.billingconductor.model.CustomLineItemListElement
import aws.sdk.kotlin.services.billingconductor.model.CustomLineItemVersionListElement
import aws.sdk.kotlin.services.billingconductor.model.GetBillingGroupCostReportRequest
import aws.sdk.kotlin.services.billingconductor.model.GetBillingGroupCostReportResponse
import aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemVersionsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemVersionsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesResponse
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponseElement
import aws.sdk.kotlin.services.billingconductor.model.PricingPlanListElement
import aws.sdk.kotlin.services.billingconductor.model.PricingRuleListElement
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetBillingGroupCostReportResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetBillingGroupCostReportRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetBillingGroupCostReportResponse]
 */
public fun BillingconductorClient.getBillingGroupCostReportPaginated(initialRequest: GetBillingGroupCostReportRequest): Flow<GetBillingGroupCostReportResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getBillingGroupCostReportPaginated.getBillingGroupCostReport(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetBillingGroupCostReportResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetBillingGroupCostReportResponse]
 */
public fun BillingconductorClient.getBillingGroupCostReportPaginated(block: GetBillingGroupCostReportRequest.Builder.() -> Unit): Flow<GetBillingGroupCostReportResponse> =
    getBillingGroupCostReportPaginated(GetBillingGroupCostReportRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getBillingGroupCostReportPaginated]
 * to access the nested member [BillingGroupCostReportResultElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BillingGroupCostReportResultElement]
 */
@JvmName("getBillingGroupCostReportResponseBillingGroupCostReportResultElement")
public fun Flow<GetBillingGroupCostReportResponse>.billingGroupCostReportResults(): Flow<BillingGroupCostReportResultElement> =
    transform() { response ->
        response.billingGroupCostReportResults?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccountAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssociationsResponse]
 */
public fun BillingconductorClient.listAccountAssociationsPaginated(initialRequest: ListAccountAssociationsRequest = ListAccountAssociationsRequest { }): Flow<ListAccountAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountAssociationsPaginated.listAccountAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssociationsResponse]
 */
public fun BillingconductorClient.listAccountAssociationsPaginated(block: ListAccountAssociationsRequest.Builder.() -> Unit): Flow<ListAccountAssociationsResponse> =
    listAccountAssociationsPaginated(ListAccountAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccountAssociationsPaginated]
 * to access the nested member [AccountAssociationsListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAssociationsListElement]
 */
@JvmName("listAccountAssociationsResponseAccountAssociationsListElement")
public fun Flow<ListAccountAssociationsResponse>.linkedAccounts(): Flow<AccountAssociationsListElement> =
    transform() { response ->
        response.linkedAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBillingGroupCostReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBillingGroupCostReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBillingGroupCostReportsResponse]
 */
public fun BillingconductorClient.listBillingGroupCostReportsPaginated(initialRequest: ListBillingGroupCostReportsRequest = ListBillingGroupCostReportsRequest { }): Flow<ListBillingGroupCostReportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBillingGroupCostReportsPaginated.listBillingGroupCostReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBillingGroupCostReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBillingGroupCostReportsResponse]
 */
public fun BillingconductorClient.listBillingGroupCostReportsPaginated(block: ListBillingGroupCostReportsRequest.Builder.() -> Unit): Flow<ListBillingGroupCostReportsResponse> =
    listBillingGroupCostReportsPaginated(ListBillingGroupCostReportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBillingGroupCostReportsPaginated]
 * to access the nested member [BillingGroupCostReportElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BillingGroupCostReportElement]
 */
@JvmName("listBillingGroupCostReportsResponseBillingGroupCostReportElement")
public fun Flow<ListBillingGroupCostReportsResponse>.billingGroupCostReports(): Flow<BillingGroupCostReportElement> =
    transform() { response ->
        response.billingGroupCostReports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBillingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBillingGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBillingGroupsResponse]
 */
public fun BillingconductorClient.listBillingGroupsPaginated(initialRequest: ListBillingGroupsRequest = ListBillingGroupsRequest { }): Flow<ListBillingGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBillingGroupsPaginated.listBillingGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBillingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBillingGroupsResponse]
 */
public fun BillingconductorClient.listBillingGroupsPaginated(block: ListBillingGroupsRequest.Builder.() -> Unit): Flow<ListBillingGroupsResponse> =
    listBillingGroupsPaginated(ListBillingGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBillingGroupsPaginated]
 * to access the nested member [BillingGroupListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BillingGroupListElement]
 */
@JvmName("listBillingGroupsResponseBillingGroupListElement")
public fun Flow<ListBillingGroupsResponse>.billingGroups(): Flow<BillingGroupListElement> =
    transform() { response ->
        response.billingGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomLineItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomLineItemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomLineItemsResponse]
 */
public fun BillingconductorClient.listCustomLineItemsPaginated(initialRequest: ListCustomLineItemsRequest = ListCustomLineItemsRequest { }): Flow<ListCustomLineItemsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomLineItemsPaginated.listCustomLineItems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomLineItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomLineItemsResponse]
 */
public fun BillingconductorClient.listCustomLineItemsPaginated(block: ListCustomLineItemsRequest.Builder.() -> Unit): Flow<ListCustomLineItemsResponse> =
    listCustomLineItemsPaginated(ListCustomLineItemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomLineItemsPaginated]
 * to access the nested member [CustomLineItemListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomLineItemListElement]
 */
@JvmName("listCustomLineItemsResponseCustomLineItemListElement")
public fun Flow<ListCustomLineItemsResponse>.customLineItems(): Flow<CustomLineItemListElement> =
    transform() { response ->
        response.customLineItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomLineItemVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomLineItemVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomLineItemVersionsResponse]
 */
public fun BillingconductorClient.listCustomLineItemVersionsPaginated(initialRequest: ListCustomLineItemVersionsRequest): Flow<ListCustomLineItemVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomLineItemVersionsPaginated.listCustomLineItemVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomLineItemVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomLineItemVersionsResponse]
 */
public fun BillingconductorClient.listCustomLineItemVersionsPaginated(block: ListCustomLineItemVersionsRequest.Builder.() -> Unit): Flow<ListCustomLineItemVersionsResponse> =
    listCustomLineItemVersionsPaginated(ListCustomLineItemVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomLineItemVersionsPaginated]
 * to access the nested member [CustomLineItemVersionListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomLineItemVersionListElement]
 */
@JvmName("listCustomLineItemVersionsResponseCustomLineItemVersionListElement")
public fun Flow<ListCustomLineItemVersionsResponse>.customLineItemVersions(): Flow<CustomLineItemVersionListElement> =
    transform() { response ->
        response.customLineItemVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPricingPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPricingPlansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingPlansResponse]
 */
public fun BillingconductorClient.listPricingPlansPaginated(initialRequest: ListPricingPlansRequest = ListPricingPlansRequest { }): Flow<ListPricingPlansResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPricingPlansPaginated.listPricingPlans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPricingPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingPlansResponse]
 */
public fun BillingconductorClient.listPricingPlansPaginated(block: ListPricingPlansRequest.Builder.() -> Unit): Flow<ListPricingPlansResponse> =
    listPricingPlansPaginated(ListPricingPlansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPricingPlansPaginated]
 * to access the nested member [PricingPlanListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PricingPlanListElement]
 */
@JvmName("listPricingPlansResponsePricingPlanListElement")
public fun Flow<ListPricingPlansResponse>.pricingPlans(): Flow<PricingPlanListElement> =
    transform() { response ->
        response.pricingPlans?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPricingPlansAssociatedWithPricingRuleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPricingPlansAssociatedWithPricingRuleRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingPlansAssociatedWithPricingRuleResponse]
 */
public fun BillingconductorClient.listPricingPlansAssociatedWithPricingRulePaginated(initialRequest: ListPricingPlansAssociatedWithPricingRuleRequest): Flow<ListPricingPlansAssociatedWithPricingRuleResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPricingPlansAssociatedWithPricingRulePaginated.listPricingPlansAssociatedWithPricingRule(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPricingPlansAssociatedWithPricingRuleResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingPlansAssociatedWithPricingRuleResponse]
 */
public fun BillingconductorClient.listPricingPlansAssociatedWithPricingRulePaginated(block: ListPricingPlansAssociatedWithPricingRuleRequest.Builder.() -> Unit): Flow<ListPricingPlansAssociatedWithPricingRuleResponse> =
    listPricingPlansAssociatedWithPricingRulePaginated(ListPricingPlansAssociatedWithPricingRuleRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPricingPlansAssociatedWithPricingRulePaginated]
 * to access the nested member [PricingPlanArn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PricingPlanArn]
 */
@JvmName("listPricingPlansAssociatedWithPricingRuleResponsePricingPlanArn")
public fun Flow<ListPricingPlansAssociatedWithPricingRuleResponse>.pricingPlanArns(): Flow<String> =
    transform() { response ->
        response.pricingPlanArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPricingRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPricingRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingRulesResponse]
 */
public fun BillingconductorClient.listPricingRulesPaginated(initialRequest: ListPricingRulesRequest = ListPricingRulesRequest { }): Flow<ListPricingRulesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPricingRulesPaginated.listPricingRules(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPricingRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingRulesResponse]
 */
public fun BillingconductorClient.listPricingRulesPaginated(block: ListPricingRulesRequest.Builder.() -> Unit): Flow<ListPricingRulesResponse> =
    listPricingRulesPaginated(ListPricingRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPricingRulesPaginated]
 * to access the nested member [PricingRuleListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PricingRuleListElement]
 */
@JvmName("listPricingRulesResponsePricingRuleListElement")
public fun Flow<ListPricingRulesResponse>.pricingRules(): Flow<PricingRuleListElement> =
    transform() { response ->
        response.pricingRules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPricingRulesAssociatedToPricingPlanResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPricingRulesAssociatedToPricingPlanRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingRulesAssociatedToPricingPlanResponse]
 */
public fun BillingconductorClient.listPricingRulesAssociatedToPricingPlanPaginated(initialRequest: ListPricingRulesAssociatedToPricingPlanRequest): Flow<ListPricingRulesAssociatedToPricingPlanResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPricingRulesAssociatedToPricingPlanPaginated.listPricingRulesAssociatedToPricingPlan(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPricingRulesAssociatedToPricingPlanResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricingRulesAssociatedToPricingPlanResponse]
 */
public fun BillingconductorClient.listPricingRulesAssociatedToPricingPlanPaginated(block: ListPricingRulesAssociatedToPricingPlanRequest.Builder.() -> Unit): Flow<ListPricingRulesAssociatedToPricingPlanResponse> =
    listPricingRulesAssociatedToPricingPlanPaginated(ListPricingRulesAssociatedToPricingPlanRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPricingRulesAssociatedToPricingPlanPaginated]
 * to access the nested member [PricingRuleArn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PricingRuleArn]
 */
@JvmName("listPricingRulesAssociatedToPricingPlanResponsePricingRuleArn")
public fun Flow<ListPricingRulesAssociatedToPricingPlanResponse>.pricingRuleArns(): Flow<String> =
    transform() { response ->
        response.pricingRuleArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourcesAssociatedToCustomLineItemResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourcesAssociatedToCustomLineItemRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesAssociatedToCustomLineItemResponse]
 */
public fun BillingconductorClient.listResourcesAssociatedToCustomLineItemPaginated(initialRequest: ListResourcesAssociatedToCustomLineItemRequest): Flow<ListResourcesAssociatedToCustomLineItemResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourcesAssociatedToCustomLineItemPaginated.listResourcesAssociatedToCustomLineItem(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourcesAssociatedToCustomLineItemResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesAssociatedToCustomLineItemResponse]
 */
public fun BillingconductorClient.listResourcesAssociatedToCustomLineItemPaginated(block: ListResourcesAssociatedToCustomLineItemRequest.Builder.() -> Unit): Flow<ListResourcesAssociatedToCustomLineItemResponse> =
    listResourcesAssociatedToCustomLineItemPaginated(ListResourcesAssociatedToCustomLineItemRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourcesAssociatedToCustomLineItemPaginated]
 * to access the nested member [ListResourcesAssociatedToCustomLineItemResponseElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourcesAssociatedToCustomLineItemResponseElement]
 */
@JvmName("listResourcesAssociatedToCustomLineItemResponseListResourcesAssociatedToCustomLineItemResponseElement")
public fun Flow<ListResourcesAssociatedToCustomLineItemResponse>.associatedResources(): Flow<ListResourcesAssociatedToCustomLineItemResponseElement> =
    transform() { response ->
        response.associatedResources?.forEach {
            emit(it)
        }
    }
