// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The filter that specifies the billing groups and pricing plans to retrieve billing group information.
 */
public class ListBillingGroupsFilter private constructor(builder: Builder) {
    /**
     * The list of billing group Amazon Resource Names (ARNs) to retrieve information.
     */
    public val arns: List<String>? = builder.arns
    /**
     * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that join your consolidated billing family.
     */
    public val autoAssociate: kotlin.Boolean? = builder.autoAssociate
    /**
     * The pricing plan Amazon Resource Names (ARNs) to retrieve information.
     */
    public val pricingPlan: kotlin.String? = builder.pricingPlan
    /**
     * A list of billing groups to retrieve their current status for a specific time range
     */
    public val statuses: List<BillingGroupStatus>? = builder.statuses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBillingGroupsFilter(")
        append("arns=$arns,")
        append("autoAssociate=$autoAssociate,")
        append("pricingPlan=$pricingPlan,")
        append("statuses=$statuses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arns?.hashCode() ?: 0
        result = 31 * result + (autoAssociate?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (statuses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBillingGroupsFilter

        if (arns != other.arns) return false
        if (autoAssociate != other.autoAssociate) return false
        if (pricingPlan != other.pricingPlan) return false
        if (statuses != other.statuses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of billing group Amazon Resource Names (ARNs) to retrieve information.
         */
        public var arns: List<String>? = null
        /**
         * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that join your consolidated billing family.
         */
        public var autoAssociate: kotlin.Boolean? = null
        /**
         * The pricing plan Amazon Resource Names (ARNs) to retrieve information.
         */
        public var pricingPlan: kotlin.String? = null
        /**
         * A list of billing groups to retrieve their current status for a specific time range
         */
        public var statuses: List<BillingGroupStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsFilter) : this() {
            this.arns = x.arns
            this.autoAssociate = x.autoAssociate
            this.pricingPlan = x.pricingPlan
            this.statuses = x.statuses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsFilter = ListBillingGroupsFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
