// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The filter on the account ID of the linked account, or any of the following:
 *
 * `MONITORED`: linked accounts that are associated to billing groups.
 *
 * `UNMONITORED`: linked accounts that are not associated to billing groups.
 *
 * `Billing Group Arn`: linked accounts that are associated to the provided Billing Group Arn.
 */
public class ListAccountAssociationsFilter private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID to filter on.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The list of Amazon Web Services IDs to retrieve their associated billing group for a given time range.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * `MONITORED`: linked accounts that are associated to billing groups.
     *
     * `UNMONITORED`: linked accounts that are not associated to billing groups.
     *
     * `Billing Group Arn`: linked accounts that are associated to the provided Billing Group Arn.
     */
    public val association: kotlin.String? = builder.association

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAccountAssociationsFilter(")
        append("accountId=$accountId,")
        append("accountIds=$accountIds,")
        append("association=$association")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (accountIds?.hashCode() ?: 0)
        result = 31 * result + (association?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAccountAssociationsFilter

        if (accountId != other.accountId) return false
        if (accountIds != other.accountIds) return false
        if (association != other.association) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID to filter on.
         */
        public var accountId: kotlin.String? = null
        /**
         * The list of Amazon Web Services IDs to retrieve their associated billing group for a given time range.
         */
        public var accountIds: List<String>? = null
        /**
         * `MONITORED`: linked accounts that are associated to billing groups.
         *
         * `UNMONITORED`: linked accounts that are not associated to billing groups.
         *
         * `Billing Group Arn`: linked accounts that are associated to the provided Billing Group Arn.
         */
        public var association: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsFilter) : this() {
            this.accountId = x.accountId
            this.accountIds = x.accountIds
            this.association = x.association
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsFilter = ListAccountAssociationsFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
