// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A representation of a custom line item.
 */
public class CustomLineItemListElement private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account in which this custom line item will be applied to.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Names (ARNs) for custom line items.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The number of resources that are associated to the custom line item.
     */
    public val associationSize: kotlin.Long = builder.associationSize
    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    public val billingGroupArn: kotlin.String? = builder.billingGroupArn
    /**
     * A `ListCustomLineItemChargeDetails` that describes the charge details of a custom line item.
     */
    public val chargeDetails: aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemChargeDetails? = builder.chargeDetails
    /**
     * The time created.
     */
    public val creationTime: kotlin.Long = builder.creationTime
    /**
     * The custom line item's charge value currency. Only one of the valid values can be used.
     */
    public val currencyCode: aws.sdk.kotlin.services.billingconductor.model.CurrencyCode? = builder.currencyCode
    /**
     * The custom line item's description. This is shown on the Bills page in association with the charge value.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The most recent time when the custom line item was modified.
     */
    public val lastModifiedTime: kotlin.Long = builder.lastModifiedTime
    /**
     * The custom line item's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The product code that's associated with the custom line item.
     */
    public val productCode: kotlin.String? = builder.productCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CustomLineItemListElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomLineItemListElement(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("associationSize=$associationSize,")
        append("billingGroupArn=$billingGroupArn,")
        append("chargeDetails=$chargeDetails,")
        append("creationTime=$creationTime,")
        append("currencyCode=$currencyCode,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=*** Sensitive Data Redacted ***,")
        append("productCode=$productCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (associationSize.hashCode())
        result = 31 * result + (billingGroupArn?.hashCode() ?: 0)
        result = 31 * result + (chargeDetails?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomLineItemListElement

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (associationSize != other.associationSize) return false
        if (billingGroupArn != other.billingGroupArn) return false
        if (chargeDetails != other.chargeDetails) return false
        if (creationTime != other.creationTime) return false
        if (currencyCode != other.currencyCode) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (productCode != other.productCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CustomLineItemListElement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account in which this custom line item will be applied to.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Names (ARNs) for custom line items.
         */
        public var arn: kotlin.String? = null
        /**
         * The number of resources that are associated to the custom line item.
         */
        public var associationSize: kotlin.Long = 0L
        /**
         * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
         */
        public var billingGroupArn: kotlin.String? = null
        /**
         * A `ListCustomLineItemChargeDetails` that describes the charge details of a custom line item.
         */
        public var chargeDetails: aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemChargeDetails? = null
        /**
         * The time created.
         */
        public var creationTime: kotlin.Long = 0L
        /**
         * The custom line item's charge value currency. Only one of the valid values can be used.
         */
        public var currencyCode: aws.sdk.kotlin.services.billingconductor.model.CurrencyCode? = null
        /**
         * The custom line item's description. This is shown on the Bills page in association with the charge value.
         */
        public var description: kotlin.String? = null
        /**
         * The most recent time when the custom line item was modified.
         */
        public var lastModifiedTime: kotlin.Long = 0L
        /**
         * The custom line item's name.
         */
        public var name: kotlin.String? = null
        /**
         * The product code that's associated with the custom line item.
         */
        public var productCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemListElement) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.associationSize = x.associationSize
            this.billingGroupArn = x.billingGroupArn
            this.chargeDetails = x.chargeDetails
            this.creationTime = x.creationTime
            this.currencyCode = x.currencyCode
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.productCode = x.productCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CustomLineItemListElement = CustomLineItemListElement(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemChargeDetails] inside the given [block]
         */
        public fun chargeDetails(block: aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemChargeDetails.Builder.() -> kotlin.Unit) {
            this.chargeDetails = aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemChargeDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
