// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePricingRuleRequest private constructor(builder: Builder) {
    /**
     * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
     */
    public val billingEntity: kotlin.String? = builder.billingEntity
    /**
     * The token that's needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The pricing rule description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A percentage modifier that's applied on the public pricing rates.
     */
    public val modifierPercentage: kotlin.Double? = builder.modifierPercentage
    /**
     * The pricing rule name. The names must be unique to each pricing rule.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Operation is the specific Amazon Web Services action covered by this line item. This describes the specific usage of the line item.
     *
     *  If the `Scope` attribute is set to `SKU`, this attribute indicates which operation the `PricingRule` is modifying. For example, a value of `RunInstances:0202` indicates the operation of running an Amazon EC2 instance.
     */
    public val operation: kotlin.String? = builder.operation
    /**
     * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     */
    public val scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope = requireNotNull(builder.scope) { "A non-null value must be provided for scope" }
    /**
     * If the `Scope` attribute is set to `SERVICE` or `SKU`, the attribute indicates which service the `PricingRule` is applicable for.
     */
    public val service: kotlin.String? = builder.service
    /**
     * A map that contains tag keys and tag values that are attached to a pricing rule.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The set of tiering configurations for the pricing rule.
     */
    public val tiering: aws.sdk.kotlin.services.billingconductor.model.CreateTieringInput? = builder.tiering
    /**
     * The type of pricing rule.
     */
    public val type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
     *
     * If the `Scope` attribute is set to `SKU`, this attribute indicates which usage type the `PricingRule` is modifying. For example, `USW2-BoxUsage:m2.2xlarge` describes an` M2 High Memory Double Extra Large` instance in the US West (Oregon) Region.
     */
    public val usageType: kotlin.String? = builder.usageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePricingRuleRequest(")
        append("billingEntity=$billingEntity,")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("modifierPercentage=$modifierPercentage,")
        append("name=*** Sensitive Data Redacted ***,")
        append("operation=$operation,")
        append("scope=$scope,")
        append("service=$service,")
        append("tags=$tags,")
        append("tiering=$tiering,")
        append("type=$type,")
        append("usageType=$usageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingEntity?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modifierPercentage?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (scope.hashCode())
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tiering?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (usageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePricingRuleRequest

        if (billingEntity != other.billingEntity) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (!(modifierPercentage?.equals(other.modifierPercentage) ?: (other.modifierPercentage == null))) return false
        if (name != other.name) return false
        if (operation != other.operation) return false
        if (scope != other.scope) return false
        if (service != other.service) return false
        if (tags != other.tags) return false
        if (tiering != other.tiering) return false
        if (type != other.type) return false
        if (usageType != other.usageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
         */
        public var billingEntity: kotlin.String? = null
        /**
         * The token that's needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The pricing rule description.
         */
        public var description: kotlin.String? = null
        /**
         * A percentage modifier that's applied on the public pricing rates.
         */
        public var modifierPercentage: kotlin.Double? = null
        /**
         * The pricing rule name. The names must be unique to each pricing rule.
         */
        public var name: kotlin.String? = null
        /**
         * Operation is the specific Amazon Web Services action covered by this line item. This describes the specific usage of the line item.
         *
         *  If the `Scope` attribute is set to `SKU`, this attribute indicates which operation the `PricingRule` is modifying. For example, a value of `RunInstances:0202` indicates the operation of running an Amazon EC2 instance.
         */
        public var operation: kotlin.String? = null
        /**
         * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         */
        public var scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = null
        /**
         * If the `Scope` attribute is set to `SERVICE` or `SKU`, the attribute indicates which service the `PricingRule` is applicable for.
         */
        public var service: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a pricing rule.
         */
        public var tags: Map<String, String>? = null
        /**
         * The set of tiering configurations for the pricing rule.
         */
        public var tiering: aws.sdk.kotlin.services.billingconductor.model.CreateTieringInput? = null
        /**
         * The type of pricing rule.
         */
        public var type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = null
        /**
         * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
         *
         * If the `Scope` attribute is set to `SKU`, this attribute indicates which usage type the `PricingRule` is modifying. For example, `USW2-BoxUsage:m2.2xlarge` describes an` M2 High Memory Double Extra Large` instance in the US West (Oregon) Region.
         */
        public var usageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest) : this() {
            this.billingEntity = x.billingEntity
            this.clientToken = x.clientToken
            this.description = x.description
            this.modifierPercentage = x.modifierPercentage
            this.name = x.name
            this.operation = x.operation
            this.scope = x.scope
            this.service = x.service
            this.tags = x.tags
            this.tiering = x.tiering
            this.type = x.type
            this.usageType = x.usageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = CreatePricingRuleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.CreateTieringInput] inside the given [block]
         */
        public fun tiering(block: aws.sdk.kotlin.services.billingconductor.model.CreateTieringInput.Builder.() -> kotlin.Unit) {
            this.tiering = aws.sdk.kotlin.services.billingconductor.model.CreateTieringInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (scope == null) scope = PricingRuleScope.SdkUnknown("no value provided")
            if (type == null) type = PricingRuleType.SdkUnknown("no value provided")
            return this
        }
    }
}
