// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.billingconductor.auth.BillingconductorAuthSchemeProvider
import aws.sdk.kotlin.services.billingconductor.auth.DefaultBillingconductorAuthSchemeProvider
import aws.sdk.kotlin.services.billingconductor.endpoints.BillingconductorEndpointParameters
import aws.sdk.kotlin.services.billingconductor.endpoints.BillingconductorEndpointProvider
import aws.sdk.kotlin.services.billingconductor.endpoints.DefaultBillingconductorEndpointProvider
import aws.sdk.kotlin.services.billingconductor.model.AssociateAccountsRequest
import aws.sdk.kotlin.services.billingconductor.model.AssociateAccountsResponse
import aws.sdk.kotlin.services.billingconductor.model.AssociatePricingRulesRequest
import aws.sdk.kotlin.services.billingconductor.model.AssociatePricingRulesResponse
import aws.sdk.kotlin.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupRequest
import aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupResponse
import aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.CreatePricingPlanRequest
import aws.sdk.kotlin.services.billingconductor.model.CreatePricingPlanResponse
import aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest
import aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleResponse
import aws.sdk.kotlin.services.billingconductor.model.DeleteBillingGroupRequest
import aws.sdk.kotlin.services.billingconductor.model.DeleteBillingGroupResponse
import aws.sdk.kotlin.services.billingconductor.model.DeleteCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.DeleteCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.DeletePricingPlanRequest
import aws.sdk.kotlin.services.billingconductor.model.DeletePricingPlanResponse
import aws.sdk.kotlin.services.billingconductor.model.DeletePricingRuleRequest
import aws.sdk.kotlin.services.billingconductor.model.DeletePricingRuleResponse
import aws.sdk.kotlin.services.billingconductor.model.DisassociateAccountsRequest
import aws.sdk.kotlin.services.billingconductor.model.DisassociateAccountsResponse
import aws.sdk.kotlin.services.billingconductor.model.DisassociatePricingRulesRequest
import aws.sdk.kotlin.services.billingconductor.model.DisassociatePricingRulesResponse
import aws.sdk.kotlin.services.billingconductor.model.GetBillingGroupCostReportRequest
import aws.sdk.kotlin.services.billingconductor.model.GetBillingGroupCostReportResponse
import aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemVersionsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemVersionsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingPlansResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesRequest
import aws.sdk.kotlin.services.billingconductor.model.ListPricingRulesResponse
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.billingconductor.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.billingconductor.model.TagResourceRequest
import aws.sdk.kotlin.services.billingconductor.model.TagResourceResponse
import aws.sdk.kotlin.services.billingconductor.model.UntagResourceRequest
import aws.sdk.kotlin.services.billingconductor.model.UntagResourceResponse
import aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupRequest
import aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupResponse
import aws.sdk.kotlin.services.billingconductor.model.UpdateCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.UpdateCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.UpdatePricingPlanRequest
import aws.sdk.kotlin.services.billingconductor.model.UpdatePricingPlanResponse
import aws.sdk.kotlin.services.billingconductor.model.UpdatePricingRuleRequest
import aws.sdk.kotlin.services.billingconductor.model.UpdatePricingRuleResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "billingconductor"
public const val SdkVersion: String = "1.3.49"
public const val ServiceApiVersion: String = "2021-07-30"

/**
 * Amazon Web Services Billing Conductor is a fully managed service that you can use to customize a [proforma](https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html#eb-other-definitions) version of your billing data each month, to accurately show or chargeback your end customers. Amazon Web Services Billing Conductor doesn't change the way you're billed by Amazon Web Services each month by design. Instead, it provides you with a mechanism to configure, generate, and display rates to certain customers over a given billing period. You can also analyze the difference between the rates you apply to your accounting groupings relative to your actual rates from Amazon Web Services. As a result of your Amazon Web Services Billing Conductor configuration, the payer account can also see the custom rate applied on the billing details page of the [Amazon Web Services Billing console](https://console.aws.amazon.com/billing), or configure a cost and usage report per billing group.
 *
 * This documentation shows how you can configure Amazon Web Services Billing Conductor using its API. For more information about using the [Amazon Web Services Billing Conductor](https://console.aws.amazon.com/billingconductor/) user interface, see the [ Amazon Web Services Billing Conductor User Guide](https://docs.aws.amazon.com/billingconductor/latest/userguide/what-is-billingconductor.html).
 */
public interface BillingconductorClient : SdkClient {
    /**
     * BillingconductorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BillingconductorClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Billingconductor",
                "BILLINGCONDUCTOR",
                "billingconductor",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BillingconductorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BillingconductorClient = DefaultBillingconductorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BillingconductorEndpointProvider = builder.endpointProvider ?: DefaultBillingconductorEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: BillingconductorAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBillingconductorAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "billingconductor"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BillingconductorEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BillingconductorAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30.
     */
    public suspend fun associateAccounts(input: AssociateAccountsRequest): AssociateAccountsResponse

    /**
     * Connects an array of `PricingRuleArns` to a defined `PricingPlan`. The maximum number `PricingRuleArn` that can be associated in one call is 30.
     */
    public suspend fun associatePricingRules(input: AssociatePricingRulesRequest): AssociatePricingRulesResponse

    /**
     * Associates a batch of resources to a percentage custom line item.
     */
    public suspend fun batchAssociateResourcesToCustomLineItem(input: BatchAssociateResourcesToCustomLineItemRequest): BatchAssociateResourcesToCustomLineItemResponse

    /**
     * Disassociates a batch of resources from a percentage custom line item.
     */
    public suspend fun batchDisassociateResourcesFromCustomLineItem(input: BatchDisassociateResourcesFromCustomLineItemRequest): BatchDisassociateResourcesFromCustomLineItemResponse

    /**
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.
     */
    public suspend fun createBillingGroup(input: CreateBillingGroupRequest): CreateBillingGroupResponse

    /**
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     */
    public suspend fun createCustomLineItem(input: CreateCustomLineItemRequest): CreateCustomLineItemResponse

    /**
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     */
    public suspend fun createPricingPlan(input: CreatePricingPlanRequest): CreatePricingPlanResponse

    /**
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     */
    public suspend fun createPricingRule(input: CreatePricingRuleRequest): CreatePricingRuleResponse

    /**
     * Deletes a billing group.
     */
    public suspend fun deleteBillingGroup(input: DeleteBillingGroupRequest): DeleteBillingGroupResponse

    /**
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     */
    public suspend fun deleteCustomLineItem(input: DeleteCustomLineItemRequest): DeleteCustomLineItemResponse

    /**
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     */
    public suspend fun deletePricingPlan(input: DeletePricingPlanRequest): DeletePricingPlanResponse

    /**
     * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
     */
    public suspend fun deletePricingRule(input: DeletePricingRuleRequest): DeletePricingRuleResponse

    /**
     * Removes the specified list of account IDs from the given billing group.
     */
    public suspend fun disassociateAccounts(input: DisassociateAccountsRequest): DisassociateAccountsResponse

    /**
     * Disassociates a list of pricing rules from a pricing plan.
     */
    public suspend fun disassociatePricingRules(input: DisassociatePricingRulesRequest): DisassociatePricingRulesResponse

    /**
     * Retrieves the margin summary report, which includes the Amazon Web Services cost and charged amount (pro forma cost) by Amazon Web Service for a specific billing group.
     */
    public suspend fun getBillingGroupCostReport(input: GetBillingGroupCostReportRequest): GetBillingGroupCostReportResponse

    /**
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group that's associated with the linked account.
     */
    public suspend fun listAccountAssociations(input: ListAccountAssociationsRequest = ListAccountAssociationsRequest { }): ListAccountAssociationsResponse

    /**
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    public suspend fun listBillingGroupCostReports(input: ListBillingGroupCostReportsRequest = ListBillingGroupCostReportsRequest { }): ListBillingGroupCostReportsResponse

    /**
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.
     */
    public suspend fun listBillingGroups(input: ListBillingGroupsRequest = ListBillingGroupsRequest { }): ListBillingGroupsResponse

    /**
     * A paginated call to get a list of all custom line item versions.
     */
    public suspend fun listCustomLineItemVersions(input: ListCustomLineItemVersionsRequest): ListCustomLineItemVersionsResponse

    /**
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    public suspend fun listCustomLineItems(input: ListCustomLineItemsRequest = ListCustomLineItemsRequest { }): ListCustomLineItemsResponse

    /**
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    public suspend fun listPricingPlans(input: ListPricingPlansRequest = ListPricingPlansRequest { }): ListPricingPlansResponse

    /**
     * A list of the pricing plans that are associated with a pricing rule.
     */
    public suspend fun listPricingPlansAssociatedWithPricingRule(input: ListPricingPlansAssociatedWithPricingRuleRequest): ListPricingPlansAssociatedWithPricingRuleResponse

    /**
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     */
    public suspend fun listPricingRules(input: ListPricingRulesRequest = ListPricingRulesRequest { }): ListPricingRulesResponse

    /**
     * Lists the pricing rules that are associated with a pricing plan.
     */
    public suspend fun listPricingRulesAssociatedToPricingPlan(input: ListPricingRulesAssociatedToPricingPlanRequest): ListPricingRulesAssociatedToPricingPlanResponse

    /**
     * List the resources that are associated to a custom line item.
     */
    public suspend fun listResourcesAssociatedToCustomLineItem(input: ListResourcesAssociatedToCustomLineItemRequest): ListResourcesAssociatedToCustomLineItemResponse

    /**
     * A list the tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This updates an existing billing group.
     */
    public suspend fun updateBillingGroup(input: UpdateBillingGroupRequest): UpdateBillingGroupResponse

    /**
     * Update an existing custom line item in the current or previous billing period.
     */
    public suspend fun updateCustomLineItem(input: UpdateCustomLineItemRequest): UpdateCustomLineItemResponse

    /**
     * This updates an existing pricing plan.
     */
    public suspend fun updatePricingPlan(input: UpdatePricingPlanRequest): UpdatePricingPlanResponse

    /**
     * Updates an existing pricing rule.
     */
    public suspend fun updatePricingRule(input: UpdatePricingRuleRequest): UpdatePricingRuleResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BillingconductorClient.withConfig(block: BillingconductorClient.Config.Builder.() -> Unit): BillingconductorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBillingconductorClient(newConfig)
}

/**
 * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30.
 */
public suspend inline fun BillingconductorClient.associateAccounts(crossinline block: AssociateAccountsRequest.Builder.() -> Unit): AssociateAccountsResponse = associateAccounts(AssociateAccountsRequest.Builder().apply(block).build())

/**
 * Connects an array of `PricingRuleArns` to a defined `PricingPlan`. The maximum number `PricingRuleArn` that can be associated in one call is 30.
 */
public suspend inline fun BillingconductorClient.associatePricingRules(crossinline block: AssociatePricingRulesRequest.Builder.() -> Unit): AssociatePricingRulesResponse = associatePricingRules(AssociatePricingRulesRequest.Builder().apply(block).build())

/**
 * Associates a batch of resources to a percentage custom line item.
 */
public suspend inline fun BillingconductorClient.batchAssociateResourcesToCustomLineItem(crossinline block: BatchAssociateResourcesToCustomLineItemRequest.Builder.() -> Unit): BatchAssociateResourcesToCustomLineItemResponse = batchAssociateResourcesToCustomLineItem(BatchAssociateResourcesToCustomLineItemRequest.Builder().apply(block).build())

/**
 * Disassociates a batch of resources from a percentage custom line item.
 */
public suspend inline fun BillingconductorClient.batchDisassociateResourcesFromCustomLineItem(crossinline block: BatchDisassociateResourcesFromCustomLineItemRequest.Builder.() -> Unit): BatchDisassociateResourcesFromCustomLineItemResponse = batchDisassociateResourcesFromCustomLineItem(BatchDisassociateResourcesFromCustomLineItemRequest.Builder().apply(block).build())

/**
 * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.
 */
public suspend inline fun BillingconductorClient.createBillingGroup(crossinline block: CreateBillingGroupRequest.Builder.() -> Unit): CreateBillingGroupResponse = createBillingGroup(CreateBillingGroupRequest.Builder().apply(block).build())

/**
 * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
 */
public suspend inline fun BillingconductorClient.createCustomLineItem(crossinline block: CreateCustomLineItemRequest.Builder.() -> Unit): CreateCustomLineItemResponse = createCustomLineItem(CreateCustomLineItemRequest.Builder().apply(block).build())

/**
 * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
 */
public suspend inline fun BillingconductorClient.createPricingPlan(crossinline block: CreatePricingPlanRequest.Builder.() -> Unit): CreatePricingPlanResponse = createPricingPlan(CreatePricingPlanRequest.Builder().apply(block).build())

/**
 * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
 */
public suspend inline fun BillingconductorClient.createPricingRule(crossinline block: CreatePricingRuleRequest.Builder.() -> Unit): CreatePricingRuleResponse = createPricingRule(CreatePricingRuleRequest.Builder().apply(block).build())

/**
 * Deletes a billing group.
 */
public suspend inline fun BillingconductorClient.deleteBillingGroup(crossinline block: DeleteBillingGroupRequest.Builder.() -> Unit): DeleteBillingGroupResponse = deleteBillingGroup(DeleteBillingGroupRequest.Builder().apply(block).build())

/**
 * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
 */
public suspend inline fun BillingconductorClient.deleteCustomLineItem(crossinline block: DeleteCustomLineItemRequest.Builder.() -> Unit): DeleteCustomLineItemResponse = deleteCustomLineItem(DeleteCustomLineItemRequest.Builder().apply(block).build())

/**
 * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
 */
public suspend inline fun BillingconductorClient.deletePricingPlan(crossinline block: DeletePricingPlanRequest.Builder.() -> Unit): DeletePricingPlanResponse = deletePricingPlan(DeletePricingPlanRequest.Builder().apply(block).build())

/**
 * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
 */
public suspend inline fun BillingconductorClient.deletePricingRule(crossinline block: DeletePricingRuleRequest.Builder.() -> Unit): DeletePricingRuleResponse = deletePricingRule(DeletePricingRuleRequest.Builder().apply(block).build())

/**
 * Removes the specified list of account IDs from the given billing group.
 */
public suspend inline fun BillingconductorClient.disassociateAccounts(crossinline block: DisassociateAccountsRequest.Builder.() -> Unit): DisassociateAccountsResponse = disassociateAccounts(DisassociateAccountsRequest.Builder().apply(block).build())

/**
 * Disassociates a list of pricing rules from a pricing plan.
 */
public suspend inline fun BillingconductorClient.disassociatePricingRules(crossinline block: DisassociatePricingRulesRequest.Builder.() -> Unit): DisassociatePricingRulesResponse = disassociatePricingRules(DisassociatePricingRulesRequest.Builder().apply(block).build())

/**
 * Retrieves the margin summary report, which includes the Amazon Web Services cost and charged amount (pro forma cost) by Amazon Web Service for a specific billing group.
 */
public suspend inline fun BillingconductorClient.getBillingGroupCostReport(crossinline block: GetBillingGroupCostReportRequest.Builder.() -> Unit): GetBillingGroupCostReportResponse = getBillingGroupCostReport(GetBillingGroupCostReportRequest.Builder().apply(block).build())

/**
 * This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group that's associated with the linked account.
 */
public suspend inline fun BillingconductorClient.listAccountAssociations(crossinline block: ListAccountAssociationsRequest.Builder.() -> Unit): ListAccountAssociationsResponse = listAccountAssociations(ListAccountAssociationsRequest.Builder().apply(block).build())

/**
 * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.
 */
public suspend inline fun BillingconductorClient.listBillingGroupCostReports(crossinline block: ListBillingGroupCostReportsRequest.Builder.() -> Unit): ListBillingGroupCostReportsResponse = listBillingGroupCostReports(ListBillingGroupCostReportsRequest.Builder().apply(block).build())

/**
 * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.
 */
public suspend inline fun BillingconductorClient.listBillingGroups(crossinline block: ListBillingGroupsRequest.Builder.() -> Unit): ListBillingGroupsResponse = listBillingGroups(ListBillingGroupsRequest.Builder().apply(block).build())

/**
 * A paginated call to get a list of all custom line item versions.
 */
public suspend inline fun BillingconductorClient.listCustomLineItemVersions(crossinline block: ListCustomLineItemVersionsRequest.Builder.() -> Unit): ListCustomLineItemVersionsResponse = listCustomLineItemVersions(ListCustomLineItemVersionsRequest.Builder().apply(block).build())

/**
 * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.
 */
public suspend inline fun BillingconductorClient.listCustomLineItems(crossinline block: ListCustomLineItemsRequest.Builder.() -> Unit): ListCustomLineItemsResponse = listCustomLineItems(ListCustomLineItemsRequest.Builder().apply(block).build())

/**
 * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.
 */
public suspend inline fun BillingconductorClient.listPricingPlans(crossinline block: ListPricingPlansRequest.Builder.() -> Unit): ListPricingPlansResponse = listPricingPlans(ListPricingPlansRequest.Builder().apply(block).build())

/**
 * A list of the pricing plans that are associated with a pricing rule.
 */
public suspend inline fun BillingconductorClient.listPricingPlansAssociatedWithPricingRule(crossinline block: ListPricingPlansAssociatedWithPricingRuleRequest.Builder.() -> Unit): ListPricingPlansAssociatedWithPricingRuleResponse = listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRuleRequest.Builder().apply(block).build())

/**
 * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
 */
public suspend inline fun BillingconductorClient.listPricingRules(crossinline block: ListPricingRulesRequest.Builder.() -> Unit): ListPricingRulesResponse = listPricingRules(ListPricingRulesRequest.Builder().apply(block).build())

/**
 * Lists the pricing rules that are associated with a pricing plan.
 */
public suspend inline fun BillingconductorClient.listPricingRulesAssociatedToPricingPlan(crossinline block: ListPricingRulesAssociatedToPricingPlanRequest.Builder.() -> Unit): ListPricingRulesAssociatedToPricingPlanResponse = listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanRequest.Builder().apply(block).build())

/**
 * List the resources that are associated to a custom line item.
 */
public suspend inline fun BillingconductorClient.listResourcesAssociatedToCustomLineItem(crossinline block: ListResourcesAssociatedToCustomLineItemRequest.Builder.() -> Unit): ListResourcesAssociatedToCustomLineItemResponse = listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemRequest.Builder().apply(block).build())

/**
 * A list the tags for a resource.
 */
public suspend inline fun BillingconductorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed.
 */
public suspend inline fun BillingconductorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
public suspend inline fun BillingconductorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This updates an existing billing group.
 */
public suspend inline fun BillingconductorClient.updateBillingGroup(crossinline block: UpdateBillingGroupRequest.Builder.() -> Unit): UpdateBillingGroupResponse = updateBillingGroup(UpdateBillingGroupRequest.Builder().apply(block).build())

/**
 * Update an existing custom line item in the current or previous billing period.
 */
public suspend inline fun BillingconductorClient.updateCustomLineItem(crossinline block: UpdateCustomLineItemRequest.Builder.() -> Unit): UpdateCustomLineItemResponse = updateCustomLineItem(UpdateCustomLineItemRequest.Builder().apply(block).build())

/**
 * This updates an existing pricing plan.
 */
public suspend inline fun BillingconductorClient.updatePricingPlan(crossinline block: UpdatePricingPlanRequest.Builder.() -> Unit): UpdatePricingPlanResponse = updatePricingPlan(UpdatePricingPlanRequest.Builder().apply(block).build())

/**
 * Updates an existing pricing rule.
 */
public suspend inline fun BillingconductorClient.updatePricingRule(crossinline block: UpdatePricingRuleRequest.Builder.() -> Unit): UpdatePricingRuleResponse = updatePricingRule(UpdatePricingRuleRequest.Builder().apply(block).build())
