// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateCustomLineItemRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account in which this custom line item will be applied to.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    public val billingGroupArn: kotlin.String = requireNotNull(builder.billingGroupArn) { "A non-null value must be provided for billingGroupArn" }
    /**
     * A time range for which the custom line item is effective.
     */
    public val billingPeriodRange: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange? = builder.billingPeriodRange
    /**
     * A `CustomLineItemChargeDetails` that describes the charge details for a custom line item.
     */
    public val chargeDetails: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails? = builder.chargeDetails
    /**
     * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the custom line item. This is shown on the Bills page in association with the charge value.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The name of the custom line item.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A map that contains tag keys and tag values that are attached to a custom line item.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomLineItemRequest(")
        append("accountId=$accountId,")
        append("billingGroupArn=$billingGroupArn,")
        append("billingPeriodRange=$billingPeriodRange,")
        append("chargeDetails=$chargeDetails,")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (billingGroupArn.hashCode())
        result = 31 * result + (billingPeriodRange?.hashCode() ?: 0)
        result = 31 * result + (chargeDetails?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomLineItemRequest

        if (accountId != other.accountId) return false
        if (billingGroupArn != other.billingGroupArn) return false
        if (billingPeriodRange != other.billingPeriodRange) return false
        if (chargeDetails != other.chargeDetails) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account in which this custom line item will be applied to.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
         */
        public var billingGroupArn: kotlin.String? = null
        /**
         * A time range for which the custom line item is effective.
         */
        public var billingPeriodRange: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange? = null
        /**
         * A `CustomLineItemChargeDetails` that describes the charge details for a custom line item.
         */
        public var chargeDetails: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails? = null
        /**
         * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description of the custom line item. This is shown on the Bills page in association with the charge value.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the custom line item.
         */
        public var name: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a custom line item.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest) : this() {
            this.accountId = x.accountId
            this.billingGroupArn = x.billingGroupArn
            this.billingPeriodRange = x.billingPeriodRange
            this.chargeDetails = x.chargeDetails
            this.clientToken = x.clientToken
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest = CreateCustomLineItemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange] inside the given [block]
         */
        public fun billingPeriodRange(block: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange.Builder.() -> kotlin.Unit) {
            this.billingPeriodRange = aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails] inside the given [block]
         */
        public fun chargeDetails(block: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails.Builder.() -> kotlin.Unit) {
            this.chargeDetails = aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (billingGroupArn == null) billingGroupArn = ""
            if (description == null) description = ""
            if (name == null) name = ""
            return this
        }
    }
}
