// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A paginated call to retrieve a list of summary reports of actual Amazon Web Services charges and the calculated Amazon Web Services charges, broken down by attributes.
 */
public class BillingGroupCostReportResultElement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) that uniquely identifies the billing group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The list of key-value pairs that represent the attributes by which the `BillingGroupCostReportResults` are grouped. For example, if you want the Amazon S3 service-level breakdown of a billing group for November 2023, the attributes list will contain a key-value pair of `"PRODUCT_NAME"` and `"S3"` and a key-value pair of `"BILLING_PERIOD"` and `"Nov 2023"`.
     */
    public val attributes: List<Attribute>? = builder.attributes
    /**
     * The actual Amazon Web Services charges for the billing group.
     */
    public val awsCost: kotlin.String? = builder.awsCost
    /**
     * The displayed currency.
     */
    public val currency: kotlin.String? = builder.currency
    /**
     * The billing group margin.
     */
    public val margin: kotlin.String? = builder.margin
    /**
     * The percentage of the billing group margin.
     */
    public val marginPercentage: kotlin.String? = builder.marginPercentage
    /**
     * The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    public val proformaCost: kotlin.String? = builder.proformaCost

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportResultElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BillingGroupCostReportResultElement(")
        append("arn=$arn,")
        append("attributes=$attributes,")
        append("awsCost=$awsCost,")
        append("currency=$currency,")
        append("margin=$margin,")
        append("marginPercentage=$marginPercentage,")
        append("proformaCost=$proformaCost")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (awsCost?.hashCode() ?: 0)
        result = 31 * result + (currency?.hashCode() ?: 0)
        result = 31 * result + (margin?.hashCode() ?: 0)
        result = 31 * result + (marginPercentage?.hashCode() ?: 0)
        result = 31 * result + (proformaCost?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BillingGroupCostReportResultElement

        if (arn != other.arn) return false
        if (attributes != other.attributes) return false
        if (awsCost != other.awsCost) return false
        if (currency != other.currency) return false
        if (margin != other.margin) return false
        if (marginPercentage != other.marginPercentage) return false
        if (proformaCost != other.proformaCost) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportResultElement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Number (ARN) that uniquely identifies the billing group.
         */
        public var arn: kotlin.String? = null
        /**
         * The list of key-value pairs that represent the attributes by which the `BillingGroupCostReportResults` are grouped. For example, if you want the Amazon S3 service-level breakdown of a billing group for November 2023, the attributes list will contain a key-value pair of `"PRODUCT_NAME"` and `"S3"` and a key-value pair of `"BILLING_PERIOD"` and `"Nov 2023"`.
         */
        public var attributes: List<Attribute>? = null
        /**
         * The actual Amazon Web Services charges for the billing group.
         */
        public var awsCost: kotlin.String? = null
        /**
         * The displayed currency.
         */
        public var currency: kotlin.String? = null
        /**
         * The billing group margin.
         */
        public var margin: kotlin.String? = null
        /**
         * The percentage of the billing group margin.
         */
        public var marginPercentage: kotlin.String? = null
        /**
         * The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
         */
        public var proformaCost: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportResultElement) : this() {
            this.arn = x.arn
            this.attributes = x.attributes
            this.awsCost = x.awsCost
            this.currency = x.currency
            this.margin = x.margin
            this.marginPercentage = x.marginPercentage
            this.proformaCost = x.proformaCost
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportResultElement = BillingGroupCostReportResultElement(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
