// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.serde

import aws.sdk.kotlin.services.billingconductor.model.AccountGrouping
import aws.sdk.kotlin.services.billingconductor.model.ComputationPreference
import aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBillingGroupOperationSerializer: HttpSerializer.NonStreaming<CreateBillingGroupRequest> {
    override fun serialize(context: ExecutionContext, input: CreateBillingGroupRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/create-billing-group"
        }

        builder.headers {
            append("X-Amzn-Client-Token", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
        }

        val payload = serializeCreateBillingGroupOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBillingGroupOperationBody(context: ExecutionContext, input: CreateBillingGroupRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCOUNTGROUPING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AccountGrouping"))
    val COMPUTATIONPREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ComputationPreference"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PRIMARYACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PrimaryAccountId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTGROUPING_DESCRIPTOR)
        field(COMPUTATIONPREFERENCE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRIMARYACCOUNTID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accountGrouping?.let { field(ACCOUNTGROUPING_DESCRIPTOR, it, ::serializeAccountGroupingDocument) }
        input.computationPreference?.let { field(COMPUTATIONPREFERENCE_DESCRIPTOR, it, ::serializeComputationPreferenceDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        field(NAME_DESCRIPTOR, input.name)
        input.primaryAccountId?.let { field(PRIMARYACCOUNTID_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
