// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateBillingGroupRequest private constructor(builder: Builder) {
    /**
     * Specifies if the billing group has automatic account association (`AutoAssociate`) enabled.
     */
    public val accountGrouping: aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupAccountGrouping? = builder.accountGrouping
    /**
     * The Amazon Resource Name (ARN) of the billing group being updated.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
     */
    public val computationPreference: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference? = builder.computationPreference
    /**
     * A description of the billing group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the billing group. The names must be unique to each billing group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the billing group. Only one of the valid values can be used.
     */
    public val status: aws.sdk.kotlin.services.billingconductor.model.BillingGroupStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBillingGroupRequest(")
        append("accountGrouping=$accountGrouping,")
        append("arn=$arn,")
        append("computationPreference=$computationPreference,")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountGrouping?.hashCode() ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (computationPreference?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateBillingGroupRequest

        if (accountGrouping != other.accountGrouping) return false
        if (arn != other.arn) return false
        if (computationPreference != other.computationPreference) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies if the billing group has automatic account association (`AutoAssociate`) enabled.
         */
        public var accountGrouping: aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupAccountGrouping? = null
        /**
         * The Amazon Resource Name (ARN) of the billing group being updated.
         */
        public var arn: kotlin.String? = null
        /**
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
         */
        public var computationPreference: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference? = null
        /**
         * A description of the billing group.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the billing group. The names must be unique to each billing group.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the billing group. Only one of the valid values can be used.
         */
        public var status: aws.sdk.kotlin.services.billingconductor.model.BillingGroupStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupRequest) : this() {
            this.accountGrouping = x.accountGrouping
            this.arn = x.arn
            this.computationPreference = x.computationPreference
            this.description = x.description
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupRequest = UpdateBillingGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupAccountGrouping] inside the given [block]
         */
        public fun accountGrouping(block: aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupAccountGrouping.Builder.() -> kotlin.Unit) {
            this.accountGrouping = aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupAccountGrouping.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.ComputationPreference] inside the given [block]
         */
        public fun computationPreference(block: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference.Builder.() -> kotlin.Unit) {
            this.computationPreference = aws.sdk.kotlin.services.billingconductor.model.ComputationPreference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            return this
        }
    }
}
