// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A representation of a pricing rule.
 */
public class PricingRuleListElement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The pricing plans count that this pricing rule is associated with.
     */
    public val associatedPricingPlanCount: kotlin.Long = builder.associatedPricingPlanCount
    /**
     * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
     */
    public val billingEntity: kotlin.String? = builder.billingEntity
    /**
     * The time when the pricing rule was created.
     */
    public val creationTime: kotlin.Long = builder.creationTime
    /**
     * The pricing rule description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The most recent time when the pricing rule was modified.
     */
    public val lastModifiedTime: kotlin.Long = builder.lastModifiedTime
    /**
     * A percentage modifier applied on the public pricing rates.
     */
    public val modifierPercentage: kotlin.Double? = builder.modifierPercentage
    /**
     * The name of a pricing rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Operation is the specific Amazon Web Services action covered by this line item. This describes the specific usage of the line item.
     *
     *  If the `Scope` attribute is set to `SKU`, this attribute indicates which operation the `PricingRule` is modifying. For example, a value of `RunInstances:0202` indicates the operation of running an Amazon EC2 instance.
     */
    public val operation: kotlin.String? = builder.operation
    /**
     * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
     */
    public val scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = builder.scope
    /**
     * If the `Scope` attribute is `SERVICE`, this attribute indicates which service the `PricingRule` is applicable for.
     */
    public val service: kotlin.String? = builder.service
    /**
     * The set of tiering configurations for the pricing rule.
     */
    public val tiering: aws.sdk.kotlin.services.billingconductor.model.Tiering? = builder.tiering
    /**
     * The type of pricing rule.
     */
    public val type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = builder.type
    /**
     * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
     *
     * If the `Scope` attribute is set to `SKU`, this attribute indicates which usage type the `PricingRule` is modifying. For example, `USW2-BoxUsage:m2.2xlarge` describes an` M2 High Memory Double Extra Large` instance in the US West (Oregon) Region.
     */
    public val usageType: kotlin.String? = builder.usageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.PricingRuleListElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PricingRuleListElement(")
        append("arn=$arn,")
        append("associatedPricingPlanCount=$associatedPricingPlanCount,")
        append("billingEntity=$billingEntity,")
        append("creationTime=$creationTime,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modifierPercentage=$modifierPercentage,")
        append("name=*** Sensitive Data Redacted ***,")
        append("operation=$operation,")
        append("scope=$scope,")
        append("service=$service,")
        append("tiering=$tiering,")
        append("type=$type,")
        append("usageType=$usageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (associatedPricingPlanCount.hashCode())
        result = 31 * result + (billingEntity?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (modifierPercentage?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (tiering?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (usageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PricingRuleListElement

        if (arn != other.arn) return false
        if (associatedPricingPlanCount != other.associatedPricingPlanCount) return false
        if (billingEntity != other.billingEntity) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modifierPercentage != other.modifierPercentage) return false
        if (name != other.name) return false
        if (operation != other.operation) return false
        if (scope != other.scope) return false
        if (service != other.service) return false
        if (tiering != other.tiering) return false
        if (type != other.type) return false
        if (usageType != other.usageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.PricingRuleListElement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
         */
        public var arn: kotlin.String? = null
        /**
         * The pricing plans count that this pricing rule is associated with.
         */
        public var associatedPricingPlanCount: kotlin.Long = 0L
        /**
         * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
         */
        public var billingEntity: kotlin.String? = null
        /**
         * The time when the pricing rule was created.
         */
        public var creationTime: kotlin.Long = 0L
        /**
         * The pricing rule description.
         */
        public var description: kotlin.String? = null
        /**
         * The most recent time when the pricing rule was modified.
         */
        public var lastModifiedTime: kotlin.Long = 0L
        /**
         * A percentage modifier applied on the public pricing rates.
         */
        public var modifierPercentage: kotlin.Double? = null
        /**
         * The name of a pricing rule.
         */
        public var name: kotlin.String? = null
        /**
         * Operation is the specific Amazon Web Services action covered by this line item. This describes the specific usage of the line item.
         *
         *  If the `Scope` attribute is set to `SKU`, this attribute indicates which operation the `PricingRule` is modifying. For example, a value of `RunInstances:0202` indicates the operation of running an Amazon EC2 instance.
         */
        public var operation: kotlin.String? = null
        /**
         * The scope of pricing rule that indicates if it is globally applicable, or if it is service-specific.
         */
        public var scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = null
        /**
         * If the `Scope` attribute is `SERVICE`, this attribute indicates which service the `PricingRule` is applicable for.
         */
        public var service: kotlin.String? = null
        /**
         * The set of tiering configurations for the pricing rule.
         */
        public var tiering: aws.sdk.kotlin.services.billingconductor.model.Tiering? = null
        /**
         * The type of pricing rule.
         */
        public var type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = null
        /**
         * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
         *
         * If the `Scope` attribute is set to `SKU`, this attribute indicates which usage type the `PricingRule` is modifying. For example, `USW2-BoxUsage:m2.2xlarge` describes an` M2 High Memory Double Extra Large` instance in the US West (Oregon) Region.
         */
        public var usageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.PricingRuleListElement) : this() {
            this.arn = x.arn
            this.associatedPricingPlanCount = x.associatedPricingPlanCount
            this.billingEntity = x.billingEntity
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.modifierPercentage = x.modifierPercentage
            this.name = x.name
            this.operation = x.operation
            this.scope = x.scope
            this.service = x.service
            this.tiering = x.tiering
            this.type = x.type
            this.usageType = x.usageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.PricingRuleListElement = PricingRuleListElement(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.Tiering] inside the given [block]
         */
        public fun tiering(block: aws.sdk.kotlin.services.billingconductor.model.Tiering.Builder.() -> kotlin.Unit) {
            this.tiering = aws.sdk.kotlin.services.billingconductor.model.Tiering.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
