// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter that specifies the custom line items and billing groups to retrieve FFLI information.
 */
public class ListCustomLineItemsFilter private constructor(builder: Builder) {
    /**
     * The Amazon Web Services accounts in which this custom line item will be applied to.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * A list of custom line item ARNs to retrieve information.
     */
    public val arns: List<String>? = builder.arns
    /**
     * The billing group Amazon Resource Names (ARNs) to retrieve information.
     */
    public val billingGroups: List<String>? = builder.billingGroups
    /**
     * A list of custom line items to retrieve information.
     */
    public val names: List<String>? = builder.names

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListCustomLineItemsFilter(")
        append("accountIds=$accountIds,")
        append("arns=$arns,")
        append("billingGroups=$billingGroups,")
        append("names=$names")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (arns?.hashCode() ?: 0)
        result = 31 * result + (billingGroups?.hashCode() ?: 0)
        result = 31 * result + (names?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListCustomLineItemsFilter

        if (accountIds != other.accountIds) return false
        if (arns != other.arns) return false
        if (billingGroups != other.billingGroups) return false
        if (names != other.names) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services accounts in which this custom line item will be applied to.
         */
        public var accountIds: List<String>? = null
        /**
         * A list of custom line item ARNs to retrieve information.
         */
        public var arns: List<String>? = null
        /**
         * The billing group Amazon Resource Names (ARNs) to retrieve information.
         */
        public var billingGroups: List<String>? = null
        /**
         * A list of custom line items to retrieve information.
         */
        public var names: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsFilter) : this() {
            this.accountIds = x.accountIds
            this.arns = x.arns
            this.billingGroups = x.billingGroups
            this.names = x.names
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.ListCustomLineItemsFilter = ListCustomLineItemsFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
