// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A representation of the line item filter for your custom line item. You can use line item filters to include or exclude specific resource values from the billing group's total cost. For example, if you create a custom line item and you want to filter out a value, such as Savings Plan discounts, you can update `LineItemFilter` to exclude it.
 */
public class LineItemFilter private constructor(builder: Builder) {
    /**
     * The attribute of the line item filter. This specifies what attribute that you can filter on.
     */
    public val attribute: aws.sdk.kotlin.services.billingconductor.model.LineItemFilterAttributeName = requireNotNull(builder.attribute) { "A non-null value must be provided for attribute" }
    /**
     * The match criteria of the line item filter. This parameter specifies whether not to include the resource value from the billing group total cost.
     */
    public val matchOption: aws.sdk.kotlin.services.billingconductor.model.MatchOption = requireNotNull(builder.matchOption) { "A non-null value must be provided for matchOption" }
    /**
     * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude Savings Plan discounts.
     */
    public val values: List<LineItemFilterValue> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.LineItemFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LineItemFilter(")
        append("attribute=$attribute,")
        append("matchOption=$matchOption,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute.hashCode()
        result = 31 * result + (matchOption.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LineItemFilter

        if (attribute != other.attribute) return false
        if (matchOption != other.matchOption) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.LineItemFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The attribute of the line item filter. This specifies what attribute that you can filter on.
         */
        public var attribute: aws.sdk.kotlin.services.billingconductor.model.LineItemFilterAttributeName? = null
        /**
         * The match criteria of the line item filter. This parameter specifies whether not to include the resource value from the billing group total cost.
         */
        public var matchOption: aws.sdk.kotlin.services.billingconductor.model.MatchOption? = null
        /**
         * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude Savings Plan discounts.
         */
        public var values: List<LineItemFilterValue>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.LineItemFilter) : this() {
            this.attribute = x.attribute
            this.matchOption = x.matchOption
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.LineItemFilter = LineItemFilter(this)

        internal fun correctErrors(): Builder {
            if (attribute == null) attribute = LineItemFilterAttributeName.SdkUnknown("no value provided")
            if (matchOption == null) matchOption = MatchOption.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
