// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated billing family.
 */
public class AccountGrouping private constructor(builder: Builder) {
    /**
     * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that join your consolidated billing family.
     */
    public val autoAssociate: kotlin.Boolean? = builder.autoAssociate
    /**
     * The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group.
     */
    public val linkedAccountIds: List<String> = requireNotNull(builder.linkedAccountIds) { "A non-null value must be provided for linkedAccountIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.AccountGrouping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountGrouping(")
        append("autoAssociate=$autoAssociate,")
        append("linkedAccountIds=$linkedAccountIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoAssociate?.hashCode() ?: 0
        result = 31 * result + (linkedAccountIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountGrouping

        if (autoAssociate != other.autoAssociate) return false
        if (linkedAccountIds != other.linkedAccountIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.AccountGrouping = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies if this billing group will automatically associate newly added Amazon Web Services accounts that join your consolidated billing family.
         */
        public var autoAssociate: kotlin.Boolean? = null
        /**
         * The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family, and not associated with another billing group.
         */
        public var linkedAccountIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.AccountGrouping) : this() {
            this.autoAssociate = x.autoAssociate
            this.linkedAccountIds = x.linkedAccountIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.AccountGrouping = AccountGrouping(this)

        internal fun correctErrors(): Builder {
            if (linkedAccountIds == null) linkedAccountIds = emptyList()
            return this
        }
    }
}
