// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.billingconductor.model.BillingconductorException
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse
import aws.sdk.kotlin.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponseElement
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListResourcesAssociatedToCustomLineItemOperationDeserializer: HttpDeserialize<ListResourcesAssociatedToCustomLineItemResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListResourcesAssociatedToCustomLineItemResponse {
        if (!response.status.isSuccess()) {
            throwListResourcesAssociatedToCustomLineItemError(context, response)
        }
        val builder = ListResourcesAssociatedToCustomLineItemResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListResourcesAssociatedToCustomLineItemOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListResourcesAssociatedToCustomLineItemError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BillingconductorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BillingconductorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListResourcesAssociatedToCustomLineItemOperationBody(builder: ListResourcesAssociatedToCustomLineItemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ASSOCIATEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AssociatedResources"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ASSOCIATEDRESOURCES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ASSOCIATEDRESOURCES_DESCRIPTOR.index -> builder.associatedResources =
                    deserializer.deserializeList(ASSOCIATEDRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<ListResourcesAssociatedToCustomLineItemResponseElement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListResourcesAssociatedToCustomLineItemResponseElementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
