// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model



class CreatePricingRuleRequest private constructor(builder: Builder) {
    /**
     * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The pricing rule description.
     */
    val description: kotlin.String? = builder.description
    /**
     * A percentage modifier applied on the public pricing rates.
     */
    val modifierPercentage: kotlin.Double? = builder.modifierPercentage
    /**
     * The pricing rule name. The names must be unique to each pricing rule.
     */
    val name: kotlin.String? = builder.name
    /**
     * The scope of pricing rule that indicates if it is globally applicable, or is service-specific.
     */
    val scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = builder.scope
    /**
     * If the `Scope` attribute is set to `SERVICE`, the attribute indicates which service the `PricingRule` is applicable for.
     */
    val service: kotlin.String? = builder.service
    /**
     * A map that contains tag keys and tag values that are attached to a pricing rule.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of pricing rule.
     */
    val type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePricingRuleRequest(")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("modifierPercentage=$modifierPercentage,")
        append("name=*** Sensitive Data Redacted ***,")
        append("scope=$scope,")
        append("service=$service,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modifierPercentage?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePricingRuleRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (modifierPercentage != other.modifierPercentage) return false
        if (name != other.name) return false
        if (scope != other.scope) return false
        if (service != other.service) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
         */
        var clientToken: kotlin.String? = null
        /**
         * The pricing rule description.
         */
        var description: kotlin.String? = null
        /**
         * A percentage modifier applied on the public pricing rates.
         */
        var modifierPercentage: kotlin.Double? = null
        /**
         * The pricing rule name. The names must be unique to each pricing rule.
         */
        var name: kotlin.String? = null
        /**
         * The scope of pricing rule that indicates if it is globally applicable, or is service-specific.
         */
        var scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = null
        /**
         * If the `Scope` attribute is set to `SERVICE`, the attribute indicates which service the `PricingRule` is applicable for.
         */
        var service: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a pricing rule.
         */
        var tags: Map<String, String>? = null
        /**
         * The type of pricing rule.
         */
        var type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.modifierPercentage = x.modifierPercentage
            this.name = x.name
            this.scope = x.scope
            this.service = x.service
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = CreatePricingRuleRequest(this)
    }
}
