// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model



class CreateCustomLineItemRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    val billingGroupArn: kotlin.String? = builder.billingGroupArn
    /**
     * A time range for which the custom line item is effective.
     */
    val billingPeriodRange: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange? = builder.billingPeriodRange
    /**
     * A `CustomLineItemChargeDetails` that describes the charge details for a custom line item.
     */
    val chargeDetails: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails? = builder.chargeDetails
    /**
     * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the custom line item. This is shown on the Bills page in association with the charge value.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the custom line item.
     */
    val name: kotlin.String? = builder.name
    /**
     * A map that contains tag keys and tag values that are attached to a custom line item.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomLineItemRequest(")
        append("billingGroupArn=$billingGroupArn,")
        append("billingPeriodRange=$billingPeriodRange,")
        append("chargeDetails=$chargeDetails,")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingGroupArn?.hashCode() ?: 0
        result = 31 * result + (billingPeriodRange?.hashCode() ?: 0)
        result = 31 * result + (chargeDetails?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomLineItemRequest

        if (billingGroupArn != other.billingGroupArn) return false
        if (billingPeriodRange != other.billingPeriodRange) return false
        if (chargeDetails != other.chargeDetails) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
         */
        var billingGroupArn: kotlin.String? = null
        /**
         * A time range for which the custom line item is effective.
         */
        var billingPeriodRange: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange? = null
        /**
         * A `CustomLineItemChargeDetails` that describes the charge details for a custom line item.
         */
        var chargeDetails: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails? = null
        /**
         * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
         */
        var clientToken: kotlin.String? = null
        /**
         * The description of the custom line item. This is shown on the Bills page in association with the charge value.
         */
        var description: kotlin.String? = null
        /**
         * The name of the custom line item.
         */
        var name: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a custom line item.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest) : this() {
            this.billingGroupArn = x.billingGroupArn
            this.billingPeriodRange = x.billingPeriodRange
            this.chargeDetails = x.chargeDetails
            this.clientToken = x.clientToken
            this.description = x.description
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest = CreateCustomLineItemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange] inside the given [block]
         */
        fun billingPeriodRange(block: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange.Builder.() -> kotlin.Unit) {
            this.billingPeriodRange = aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails] inside the given [block]
         */
        fun chargeDetails(block: aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails.Builder.() -> kotlin.Unit) {
            this.chargeDetails = aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails.invoke(block)
        }
    }
}
